/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.EventsBatch;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EventsBatchMarshaller {
    private static final MarshallingInfo<StructuredPojo> ENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Endpoint").isBinary(false).build();
    private static final MarshallingInfo<Map> EVENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Events").isBinary(false).build();
    private static final EventsBatchMarshaller INSTANCE = new EventsBatchMarshaller();

    private EventsBatchMarshaller() {
    }

    public static EventsBatchMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EventsBatch eventsBatch, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)eventsBatch, (String)"eventsBatch");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)eventsBatch.endpoint(), ENDPOINT_BINDING);
            protocolMarshaller.marshall(eventsBatch.events(), EVENTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

