/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.EndpointDemographic;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EndpointDemographicMarshaller {
    private static final MarshallingInfo<String> APPVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppVersion").isBinary(false).build();
    private static final MarshallingInfo<String> LOCALE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Locale").isBinary(false).build();
    private static final MarshallingInfo<String> MAKE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Make").isBinary(false).build();
    private static final MarshallingInfo<String> MODEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Model").isBinary(false).build();
    private static final MarshallingInfo<String> MODELVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelVersion").isBinary(false).build();
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Platform").isBinary(false).build();
    private static final MarshallingInfo<String> PLATFORMVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformVersion").isBinary(false).build();
    private static final MarshallingInfo<String> TIMEZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timezone").isBinary(false).build();
    private static final EndpointDemographicMarshaller INSTANCE = new EndpointDemographicMarshaller();

    private EndpointDemographicMarshaller() {
    }

    public static EndpointDemographicMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EndpointDemographic endpointDemographic, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)endpointDemographic, (String)"endpointDemographic");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)endpointDemographic.appVersion(), APPVERSION_BINDING);
            protocolMarshaller.marshall((Object)endpointDemographic.locale(), LOCALE_BINDING);
            protocolMarshaller.marshall((Object)endpointDemographic.make(), MAKE_BINDING);
            protocolMarshaller.marshall((Object)endpointDemographic.model(), MODEL_BINDING);
            protocolMarshaller.marshall((Object)endpointDemographic.modelVersion(), MODELVERSION_BINDING);
            protocolMarshaller.marshall((Object)endpointDemographic.platform(), PLATFORM_BINDING);
            protocolMarshaller.marshall((Object)endpointDemographic.platformVersion(), PLATFORMVERSION_BINDING);
            protocolMarshaller.marshall((Object)endpointDemographic.timezone(), TIMEZONE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

