/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.DefaultPushNotificationMessage;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DefaultPushNotificationMessageMarshaller {
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").isBinary(false).build();
    private static final MarshallingInfo<String> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Body").isBinary(false).build();
    private static final MarshallingInfo<Map> DATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Data").isBinary(false).build();
    private static final MarshallingInfo<Boolean> SILENTPUSH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SilentPush").isBinary(false).build();
    private static final MarshallingInfo<Map> SUBSTITUTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Substitutions").isBinary(false).build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").isBinary(false).build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Url").isBinary(false).build();
    private static final DefaultPushNotificationMessageMarshaller INSTANCE = new DefaultPushNotificationMessageMarshaller();

    private DefaultPushNotificationMessageMarshaller() {
    }

    public static DefaultPushNotificationMessageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DefaultPushNotificationMessage defaultPushNotificationMessage, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)defaultPushNotificationMessage, (String)"defaultPushNotificationMessage");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)defaultPushNotificationMessage.actionAsString(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)defaultPushNotificationMessage.body(), BODY_BINDING);
            protocolMarshaller.marshall(defaultPushNotificationMessage.data(), DATA_BINDING);
            protocolMarshaller.marshall((Object)defaultPushNotificationMessage.silentPush(), SILENTPUSH_BINDING);
            protocolMarshaller.marshall(defaultPushNotificationMessage.substitutions(), SUBSTITUTIONS_BINDING);
            protocolMarshaller.marshall((Object)defaultPushNotificationMessage.title(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)defaultPushNotificationMessage.url(), URL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

