/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.ChannelsResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ChannelsResponseMarshaller {
    private static final MarshallingInfo<Map> CHANNELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Channels").isBinary(false).build();
    private static final ChannelsResponseMarshaller INSTANCE = new ChannelsResponseMarshaller();

    private ChannelsResponseMarshaller() {
    }

    public static ChannelsResponseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ChannelsResponse channelsResponse, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)channelsResponse, (String)"channelsResponse");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(channelsResponse.channels(), CHANNELS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

