/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.CampaignEmailMessage;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CampaignEmailMessageMarshaller {
    private static final MarshallingInfo<String> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Body").isBinary(false).build();
    private static final MarshallingInfo<String> FROMADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FromAddress").isBinary(false).build();
    private static final MarshallingInfo<String> HTMLBODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HtmlBody").isBinary(false).build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").isBinary(false).build();
    private static final CampaignEmailMessageMarshaller INSTANCE = new CampaignEmailMessageMarshaller();

    private CampaignEmailMessageMarshaller() {
    }

    public static CampaignEmailMessageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CampaignEmailMessage campaignEmailMessage, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)campaignEmailMessage, (String)"campaignEmailMessage");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)campaignEmailMessage.body(), BODY_BINDING);
            protocolMarshaller.marshall((Object)campaignEmailMessage.fromAddress(), FROMADDRESS_BINDING);
            protocolMarshaller.marshall((Object)campaignEmailMessage.htmlBody(), HTMLBODY_BINDING);
            protocolMarshaller.marshall((Object)campaignEmailMessage.title(), TITLE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

