/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.BaiduMessage;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BaiduMessageMarshaller {
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").isBinary(false).build();
    private static final MarshallingInfo<String> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Body").isBinary(false).build();
    private static final MarshallingInfo<Map> DATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Data").isBinary(false).build();
    private static final MarshallingInfo<String> ICONREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IconReference").isBinary(false).build();
    private static final MarshallingInfo<String> IMAGEICONURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageIconUrl").isBinary(false).build();
    private static final MarshallingInfo<String> IMAGEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageUrl").isBinary(false).build();
    private static final MarshallingInfo<String> RAWCONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RawContent").isBinary(false).build();
    private static final MarshallingInfo<Boolean> SILENTPUSH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SilentPush").isBinary(false).build();
    private static final MarshallingInfo<String> SMALLIMAGEICONURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SmallImageIconUrl").isBinary(false).build();
    private static final MarshallingInfo<String> SOUND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sound").isBinary(false).build();
    private static final MarshallingInfo<Map> SUBSTITUTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Substitutions").isBinary(false).build();
    private static final MarshallingInfo<Integer> TIMETOLIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeToLive").isBinary(false).build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").isBinary(false).build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Url").isBinary(false).build();
    private static final BaiduMessageMarshaller INSTANCE = new BaiduMessageMarshaller();

    private BaiduMessageMarshaller() {
    }

    public static BaiduMessageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BaiduMessage baiduMessage, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)baiduMessage, (String)"baiduMessage");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)baiduMessage.actionAsString(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)baiduMessage.body(), BODY_BINDING);
            protocolMarshaller.marshall(baiduMessage.data(), DATA_BINDING);
            protocolMarshaller.marshall((Object)baiduMessage.iconReference(), ICONREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)baiduMessage.imageIconUrl(), IMAGEICONURL_BINDING);
            protocolMarshaller.marshall((Object)baiduMessage.imageUrl(), IMAGEURL_BINDING);
            protocolMarshaller.marshall((Object)baiduMessage.rawContent(), RAWCONTENT_BINDING);
            protocolMarshaller.marshall((Object)baiduMessage.silentPush(), SILENTPUSH_BINDING);
            protocolMarshaller.marshall((Object)baiduMessage.smallImageIconUrl(), SMALLIMAGEICONURL_BINDING);
            protocolMarshaller.marshall((Object)baiduMessage.sound(), SOUND_BINDING);
            protocolMarshaller.marshall(baiduMessage.substitutions(), SUBSTITUTIONS_BINDING);
            protocolMarshaller.marshall((Object)baiduMessage.timeToLive(), TIMETOLIVE_BINDING);
            protocolMarshaller.marshall((Object)baiduMessage.title(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)baiduMessage.url(), URL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

