/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.SegmentDimensions;
import software.amazon.awssdk.services.pinpoint.model.SegmentGroupList;
import software.amazon.awssdk.services.pinpoint.transform.WriteSegmentRequestMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WriteSegmentRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, WriteSegmentRequest> {
    private final SegmentDimensions dimensions;
    private final String name;
    private final SegmentGroupList segmentGroups;

    private WriteSegmentRequest(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.name = builder.name;
        this.segmentGroups = builder.segmentGroups;
    }

    public SegmentDimensions dimensions() {
        return this.dimensions;
    }

    public String name() {
        return this.name;
    }

    public SegmentGroupList segmentGroups() {
        return this.segmentGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteSegmentRequest)) {
            return false;
        }
        WriteSegmentRequest other = (WriteSegmentRequest)obj;
        return Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.segmentGroups(), other.segmentGroups());
    }

    public String toString() {
        return ToString.builder((String)"WriteSegmentRequest").add("Dimensions", (Object)this.dimensions()).add("Name", (Object)this.name()).add("SegmentGroups", (Object)this.segmentGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SegmentGroups": {
                return Optional.ofNullable(clazz.cast(this.segmentGroups()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WriteSegmentRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private SegmentDimensions dimensions;
        private String name;
        private SegmentGroupList segmentGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteSegmentRequest model) {
            this.dimensions(model.dimensions);
            this.name(model.name);
            this.segmentGroups(model.segmentGroups);
        }

        public final SegmentDimensions.Builder getDimensions() {
            return this.dimensions != null ? this.dimensions.toBuilder() : null;
        }

        @Override
        public final Builder dimensions(SegmentDimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final void setDimensions(SegmentDimensions.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final SegmentGroupList.Builder getSegmentGroups() {
            return this.segmentGroups != null ? this.segmentGroups.toBuilder() : null;
        }

        @Override
        public final Builder segmentGroups(SegmentGroupList segmentGroups) {
            this.segmentGroups = segmentGroups;
            return this;
        }

        public final void setSegmentGroups(SegmentGroupList.BuilderImpl segmentGroups) {
            this.segmentGroups = segmentGroups != null ? segmentGroups.build() : null;
        }

        public WriteSegmentRequest build() {
            return new WriteSegmentRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WriteSegmentRequest> {
        public Builder dimensions(SegmentDimensions var1);

        default public Builder dimensions(Consumer<SegmentDimensions.Builder> dimensions) {
            return this.dimensions((SegmentDimensions)((SegmentDimensions.Builder)SegmentDimensions.builder().applyMutation(dimensions)).build());
        }

        public Builder name(String var1);

        public Builder segmentGroups(SegmentGroupList var1);

        default public Builder segmentGroups(Consumer<SegmentGroupList.Builder> segmentGroups) {
            return this.segmentGroups((SegmentGroupList)((SegmentGroupList.Builder)SegmentGroupList.builder().applyMutation(segmentGroups)).build());
        }
    }
}

