/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.ListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.transform.UpdateAttributesRequestMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAttributesRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, UpdateAttributesRequest> {
    private final List<String> blacklist;

    private UpdateAttributesRequest(BuilderImpl builder) {
        this.blacklist = builder.blacklist;
    }

    public List<String> blacklist() {
        return this.blacklist;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blacklist());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAttributesRequest)) {
            return false;
        }
        UpdateAttributesRequest other = (UpdateAttributesRequest)obj;
        return Objects.equals(this.blacklist(), other.blacklist());
    }

    public String toString() {
        return ToString.builder((String)"UpdateAttributesRequest").add("Blacklist", this.blacklist()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Blacklist": {
                return Optional.ofNullable(clazz.cast(this.blacklist()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UpdateAttributesRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> blacklist = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAttributesRequest model) {
            this.blacklist(model.blacklist);
        }

        public final Collection<String> getBlacklist() {
            return this.blacklist;
        }

        @Override
        public final Builder blacklist(Collection<String> blacklist) {
            this.blacklist = ListOf__stringCopier.copy(blacklist);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blacklist(String ... blacklist) {
            this.blacklist(Arrays.asList(blacklist));
            return this;
        }

        public final void setBlacklist(Collection<String> blacklist) {
            this.blacklist = ListOf__stringCopier.copy(blacklist);
        }

        public UpdateAttributesRequest build() {
            return new UpdateAttributesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateAttributesRequest> {
        public Builder blacklist(Collection<String> var1);

        public Builder blacklist(String ... var1);
    }
}

