/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.SessionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Session
implements StructuredPojo,
ToCopyableBuilder<Builder, Session> {
    private final Integer duration;
    private final String id;
    private final String startTimestamp;
    private final String stopTimestamp;

    private Session(BuilderImpl builder) {
        this.duration = builder.duration;
        this.id = builder.id;
        this.startTimestamp = builder.startTimestamp;
        this.stopTimestamp = builder.stopTimestamp;
    }

    public Integer duration() {
        return this.duration;
    }

    public String id() {
        return this.id;
    }

    public String startTimestamp() {
        return this.startTimestamp;
    }

    public String stopTimestamp() {
        return this.stopTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Session)) {
            return false;
        }
        Session other = (Session)obj;
        return Objects.equals(this.duration(), other.duration()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.startTimestamp(), other.startTimestamp()) && Objects.equals(this.stopTimestamp(), other.stopTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"Session").add("Duration", (Object)this.duration()).add("Id", (Object)this.id()).add("StartTimestamp", (Object)this.startTimestamp()).add("StopTimestamp", (Object)this.stopTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "StartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startTimestamp()));
            }
            case "StopTimestamp": {
                return Optional.ofNullable(clazz.cast(this.stopTimestamp()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SessionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer duration;
        private String id;
        private String startTimestamp;
        private String stopTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Session model) {
            this.duration(model.duration);
            this.id(model.id);
            this.startTimestamp(model.startTimestamp);
            this.stopTimestamp(model.stopTimestamp);
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getStartTimestamp() {
            return this.startTimestamp;
        }

        @Override
        public final Builder startTimestamp(String startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final void setStartTimestamp(String startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        public final String getStopTimestamp() {
            return this.stopTimestamp;
        }

        @Override
        public final Builder stopTimestamp(String stopTimestamp) {
            this.stopTimestamp = stopTimestamp;
            return this;
        }

        public final void setStopTimestamp(String stopTimestamp) {
            this.stopTimestamp = stopTimestamp;
        }

        public Session build() {
            return new Session(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Session> {
        public Builder duration(Integer var1);

        public Builder id(String var1);

        public Builder startTimestamp(String var1);

        public Builder stopTimestamp(String var1);
    }
}

