/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.Format;
import software.amazon.awssdk.services.pinpoint.model.MapOf__integerCopier;
import software.amazon.awssdk.services.pinpoint.transform.SegmentImportResourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SegmentImportResource
implements StructuredPojo,
ToCopyableBuilder<Builder, SegmentImportResource> {
    private final Map<String, Integer> channelCounts;
    private final String externalId;
    private final String format;
    private final String roleArn;
    private final String s3Url;
    private final Integer size;

    private SegmentImportResource(BuilderImpl builder) {
        this.channelCounts = builder.channelCounts;
        this.externalId = builder.externalId;
        this.format = builder.format;
        this.roleArn = builder.roleArn;
        this.s3Url = builder.s3Url;
        this.size = builder.size;
    }

    public Map<String, Integer> channelCounts() {
        return this.channelCounts;
    }

    public String externalId() {
        return this.externalId;
    }

    public Format format() {
        return Format.fromValue(this.format);
    }

    public String formatAsString() {
        return this.format;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String s3Url() {
        return this.s3Url;
    }

    public Integer size() {
        return this.size;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelCounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Url());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentImportResource)) {
            return false;
        }
        SegmentImportResource other = (SegmentImportResource)obj;
        return Objects.equals(this.channelCounts(), other.channelCounts()) && Objects.equals(this.externalId(), other.externalId()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.s3Url(), other.s3Url()) && Objects.equals(this.size(), other.size());
    }

    public String toString() {
        return ToString.builder((String)"SegmentImportResource").add("ChannelCounts", this.channelCounts()).add("ExternalId", (Object)this.externalId()).add("Format", (Object)this.formatAsString()).add("RoleArn", (Object)this.roleArn()).add("S3Url", (Object)this.s3Url()).add("Size", (Object)this.size()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelCounts": {
                return Optional.ofNullable(clazz.cast(this.channelCounts()));
            }
            case "ExternalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "S3Url": {
                return Optional.ofNullable(clazz.cast(this.s3Url()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SegmentImportResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, Integer> channelCounts = DefaultSdkAutoConstructMap.getInstance();
        private String externalId;
        private String format;
        private String roleArn;
        private String s3Url;
        private Integer size;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentImportResource model) {
            this.channelCounts(model.channelCounts);
            this.externalId(model.externalId);
            this.format(model.format);
            this.roleArn(model.roleArn);
            this.s3Url(model.s3Url);
            this.size(model.size);
        }

        public final Map<String, Integer> getChannelCounts() {
            return this.channelCounts;
        }

        @Override
        public final Builder channelCounts(Map<String, Integer> channelCounts) {
            this.channelCounts = MapOf__integerCopier.copy(channelCounts);
            return this;
        }

        public final void setChannelCounts(Map<String, Integer> channelCounts) {
            this.channelCounts = MapOf__integerCopier.copy(channelCounts);
        }

        public final String getExternalId() {
            return this.externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getS3Url() {
            return this.s3Url;
        }

        @Override
        public final Builder s3Url(String s3Url) {
            this.s3Url = s3Url;
            return this;
        }

        public final void setS3Url(String s3Url) {
            this.s3Url = s3Url;
        }

        public final Integer getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public SegmentImportResource build() {
            return new SegmentImportResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SegmentImportResource> {
        public Builder channelCounts(Map<String, Integer> var1);

        public Builder externalId(String var1);

        public Builder format(String var1);

        public Builder format(Format var1);

        public Builder roleArn(String var1);

        public Builder s3Url(String var1);

        public Builder size(Integer var1);
    }
}

