/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.Include;
import software.amazon.awssdk.services.pinpoint.model.ListOfSegmentGroupCopier;
import software.amazon.awssdk.services.pinpoint.model.SegmentGroup;
import software.amazon.awssdk.services.pinpoint.transform.SegmentGroupListMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SegmentGroupList
implements StructuredPojo,
ToCopyableBuilder<Builder, SegmentGroupList> {
    private final List<SegmentGroup> groups;
    private final String include;

    private SegmentGroupList(BuilderImpl builder) {
        this.groups = builder.groups;
        this.include = builder.include;
    }

    public List<SegmentGroup> groups() {
        return this.groups;
    }

    public Include include() {
        return Include.fromValue(this.include);
    }

    public String includeAsString() {
        return this.include;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentGroupList)) {
            return false;
        }
        SegmentGroupList other = (SegmentGroupList)obj;
        return Objects.equals(this.groups(), other.groups()) && Objects.equals(this.includeAsString(), other.includeAsString());
    }

    public String toString() {
        return ToString.builder((String)"SegmentGroupList").add("Groups", this.groups()).add("Include", (Object)this.includeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "Include": {
                return Optional.ofNullable(clazz.cast(this.includeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SegmentGroupListMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<SegmentGroup> groups = DefaultSdkAutoConstructList.getInstance();
        private String include;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentGroupList model) {
            this.groups(model.groups);
            this.include(model.include);
        }

        public final Collection<SegmentGroup.Builder> getGroups() {
            return this.groups != null ? (Collection)this.groups.stream().map(SegmentGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<SegmentGroup> groups) {
            this.groups = ListOfSegmentGroupCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(SegmentGroup ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<SegmentGroup.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (SegmentGroup)((SegmentGroup.Builder)SegmentGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<SegmentGroup.BuilderImpl> groups) {
            this.groups = ListOfSegmentGroupCopier.copyFromBuilder(groups);
        }

        public final String getInclude() {
            return this.include;
        }

        @Override
        public final Builder include(String include) {
            this.include = include;
            return this;
        }

        @Override
        public final Builder include(Include include) {
            this.include(include.toString());
            return this;
        }

        public final void setInclude(String include) {
            this.include = include;
        }

        public SegmentGroupList build() {
            return new SegmentGroupList(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SegmentGroupList> {
        public Builder groups(Collection<SegmentGroup> var1);

        public Builder groups(SegmentGroup ... var1);

        public Builder groups(Consumer<SegmentGroup.Builder> ... var1);

        public Builder include(String var1);

        public Builder include(Include var1);
    }
}

