/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateAttributesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveAttributesRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, RemoveAttributesRequest> {
    private final String applicationId;
    private final String attributeType;
    private final UpdateAttributesRequest updateAttributesRequest;

    private RemoveAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.attributeType = builder.attributeType;
        this.updateAttributesRequest = builder.updateAttributesRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String attributeType() {
        return this.attributeType;
    }

    public UpdateAttributesRequest updateAttributesRequest() {
        return this.updateAttributesRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateAttributesRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveAttributesRequest)) {
            return false;
        }
        RemoveAttributesRequest other = (RemoveAttributesRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.attributeType(), other.attributeType()) && Objects.equals(this.updateAttributesRequest(), other.updateAttributesRequest());
    }

    public String toString() {
        return ToString.builder((String)"RemoveAttributesRequest").add("ApplicationId", (Object)this.applicationId()).add("AttributeType", (Object)this.attributeType()).add("UpdateAttributesRequest", (Object)this.updateAttributesRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "AttributeType": {
                return Optional.ofNullable(clazz.cast(this.attributeType()));
            }
            case "UpdateAttributesRequest": {
                return Optional.ofNullable(clazz.cast(this.updateAttributesRequest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String attributeType;
        private UpdateAttributesRequest updateAttributesRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveAttributesRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.attributeType(model.attributeType);
            this.updateAttributesRequest(model.updateAttributesRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getAttributeType() {
            return this.attributeType;
        }

        @Override
        public final Builder attributeType(String attributeType) {
            this.attributeType = attributeType;
            return this;
        }

        public final void setAttributeType(String attributeType) {
            this.attributeType = attributeType;
        }

        public final UpdateAttributesRequest.Builder getUpdateAttributesRequest() {
            return this.updateAttributesRequest != null ? this.updateAttributesRequest.toBuilder() : null;
        }

        @Override
        public final Builder updateAttributesRequest(UpdateAttributesRequest updateAttributesRequest) {
            this.updateAttributesRequest = updateAttributesRequest;
            return this;
        }

        public final void setUpdateAttributesRequest(UpdateAttributesRequest.BuilderImpl updateAttributesRequest) {
            this.updateAttributesRequest = updateAttributesRequest != null ? updateAttributesRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveAttributesRequest build() {
            return new RemoveAttributesRequest(this);
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    CopyableBuilder<Builder, RemoveAttributesRequest> {
        public Builder applicationId(String var1);

        public Builder attributeType(String var1);

        public Builder updateAttributesRequest(UpdateAttributesRequest var1);

        default public Builder updateAttributesRequest(Consumer<UpdateAttributesRequest.Builder> updateAttributesRequest) {
            return this.updateAttributesRequest((UpdateAttributesRequest)((UpdateAttributesRequest.Builder)UpdateAttributesRequest.builder().applyMutation(updateAttributesRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

