/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.pinpoint.model.EventsRequest;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutEventsRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, PutEventsRequest> {
    private final String applicationId;
    private final EventsRequest eventsRequest;

    private PutEventsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.eventsRequest = builder.eventsRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public EventsRequest eventsRequest() {
        return this.eventsRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventsRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventsRequest)) {
            return false;
        }
        PutEventsRequest other = (PutEventsRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.eventsRequest(), other.eventsRequest());
    }

    public String toString() {
        return ToString.builder((String)"PutEventsRequest").add("ApplicationId", (Object)this.applicationId()).add("EventsRequest", (Object)this.eventsRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "EventsRequest": {
                return Optional.ofNullable(clazz.cast(this.eventsRequest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private EventsRequest eventsRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventsRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.eventsRequest(model.eventsRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final EventsRequest.Builder getEventsRequest() {
            return this.eventsRequest != null ? this.eventsRequest.toBuilder() : null;
        }

        @Override
        public final Builder eventsRequest(EventsRequest eventsRequest) {
            this.eventsRequest = eventsRequest;
            return this;
        }

        public final void setEventsRequest(EventsRequest.BuilderImpl eventsRequest) {
            this.eventsRequest = eventsRequest != null ? eventsRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEventsRequest build() {
            return new PutEventsRequest(this);
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    CopyableBuilder<Builder, PutEventsRequest> {
        public Builder applicationId(String var1);

        public Builder eventsRequest(EventsRequest var1);

        default public Builder eventsRequest(Consumer<EventsRequest.Builder> eventsRequest) {
            return this.eventsRequest((EventsRequest)((EventsRequest.Builder)EventsRequest.builder().applyMutation(eventsRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

