/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.NumberValidateRequestMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NumberValidateRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, NumberValidateRequest> {
    private final String isoCountryCode;
    private final String phoneNumber;

    private NumberValidateRequest(BuilderImpl builder) {
        this.isoCountryCode = builder.isoCountryCode;
        this.phoneNumber = builder.phoneNumber;
    }

    public String isoCountryCode() {
        return this.isoCountryCode;
    }

    public String phoneNumber() {
        return this.phoneNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isoCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumberValidateRequest)) {
            return false;
        }
        NumberValidateRequest other = (NumberValidateRequest)obj;
        return Objects.equals(this.isoCountryCode(), other.isoCountryCode()) && Objects.equals(this.phoneNumber(), other.phoneNumber());
    }

    public String toString() {
        return ToString.builder((String)"NumberValidateRequest").add("IsoCountryCode", (Object)this.isoCountryCode()).add("PhoneNumber", (Object)this.phoneNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IsoCountryCode": {
                return Optional.ofNullable(clazz.cast(this.isoCountryCode()));
            }
            case "PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NumberValidateRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String isoCountryCode;
        private String phoneNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(NumberValidateRequest model) {
            this.isoCountryCode(model.isoCountryCode);
            this.phoneNumber(model.phoneNumber);
        }

        public final String getIsoCountryCode() {
            return this.isoCountryCode;
        }

        @Override
        public final Builder isoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
            return this;
        }

        public final void setIsoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public NumberValidateRequest build() {
            return new NumberValidateRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NumberValidateRequest> {
        public Builder isoCountryCode(String var1);

        public Builder phoneNumber(String var1);
    }
}

