/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.Format;
import software.amazon.awssdk.services.pinpoint.transform.ImportJobResourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportJobResource
implements StructuredPojo,
ToCopyableBuilder<Builder, ImportJobResource> {
    private final Boolean defineSegment;
    private final String externalId;
    private final String format;
    private final Boolean registerEndpoints;
    private final String roleArn;
    private final String s3Url;
    private final String segmentId;
    private final String segmentName;

    private ImportJobResource(BuilderImpl builder) {
        this.defineSegment = builder.defineSegment;
        this.externalId = builder.externalId;
        this.format = builder.format;
        this.registerEndpoints = builder.registerEndpoints;
        this.roleArn = builder.roleArn;
        this.s3Url = builder.s3Url;
        this.segmentId = builder.segmentId;
        this.segmentName = builder.segmentName;
    }

    public Boolean defineSegment() {
        return this.defineSegment;
    }

    public String externalId() {
        return this.externalId;
    }

    public Format format() {
        return Format.fromValue(this.format);
    }

    public String formatAsString() {
        return this.format;
    }

    public Boolean registerEndpoints() {
        return this.registerEndpoints;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String s3Url() {
        return this.s3Url;
    }

    public String segmentId() {
        return this.segmentId;
    }

    public String segmentName() {
        return this.segmentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defineSegment());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.registerEndpoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Url());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportJobResource)) {
            return false;
        }
        ImportJobResource other = (ImportJobResource)obj;
        return Objects.equals(this.defineSegment(), other.defineSegment()) && Objects.equals(this.externalId(), other.externalId()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.registerEndpoints(), other.registerEndpoints()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.s3Url(), other.s3Url()) && Objects.equals(this.segmentId(), other.segmentId()) && Objects.equals(this.segmentName(), other.segmentName());
    }

    public String toString() {
        return ToString.builder((String)"ImportJobResource").add("DefineSegment", (Object)this.defineSegment()).add("ExternalId", (Object)this.externalId()).add("Format", (Object)this.formatAsString()).add("RegisterEndpoints", (Object)this.registerEndpoints()).add("RoleArn", (Object)this.roleArn()).add("S3Url", (Object)this.s3Url()).add("SegmentId", (Object)this.segmentId()).add("SegmentName", (Object)this.segmentName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefineSegment": {
                return Optional.ofNullable(clazz.cast(this.defineSegment()));
            }
            case "ExternalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "RegisterEndpoints": {
                return Optional.ofNullable(clazz.cast(this.registerEndpoints()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "S3Url": {
                return Optional.ofNullable(clazz.cast(this.s3Url()));
            }
            case "SegmentId": {
                return Optional.ofNullable(clazz.cast(this.segmentId()));
            }
            case "SegmentName": {
                return Optional.ofNullable(clazz.cast(this.segmentName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImportJobResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean defineSegment;
        private String externalId;
        private String format;
        private Boolean registerEndpoints;
        private String roleArn;
        private String s3Url;
        private String segmentId;
        private String segmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportJobResource model) {
            this.defineSegment(model.defineSegment);
            this.externalId(model.externalId);
            this.format(model.format);
            this.registerEndpoints(model.registerEndpoints);
            this.roleArn(model.roleArn);
            this.s3Url(model.s3Url);
            this.segmentId(model.segmentId);
            this.segmentName(model.segmentName);
        }

        public final Boolean getDefineSegment() {
            return this.defineSegment;
        }

        @Override
        public final Builder defineSegment(Boolean defineSegment) {
            this.defineSegment = defineSegment;
            return this;
        }

        public final void setDefineSegment(Boolean defineSegment) {
            this.defineSegment = defineSegment;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final Boolean getRegisterEndpoints() {
            return this.registerEndpoints;
        }

        @Override
        public final Builder registerEndpoints(Boolean registerEndpoints) {
            this.registerEndpoints = registerEndpoints;
            return this;
        }

        public final void setRegisterEndpoints(Boolean registerEndpoints) {
            this.registerEndpoints = registerEndpoints;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getS3Url() {
            return this.s3Url;
        }

        @Override
        public final Builder s3Url(String s3Url) {
            this.s3Url = s3Url;
            return this;
        }

        public final void setS3Url(String s3Url) {
            this.s3Url = s3Url;
        }

        public final String getSegmentId() {
            return this.segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        public final String getSegmentName() {
            return this.segmentName;
        }

        @Override
        public final Builder segmentName(String segmentName) {
            this.segmentName = segmentName;
            return this;
        }

        public final void setSegmentName(String segmentName) {
            this.segmentName = segmentName;
        }

        public ImportJobResource build() {
            return new ImportJobResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImportJobResource> {
        public Builder defineSegment(Boolean var1);

        public Builder externalId(String var1);

        public Builder format(String var1);

        public Builder format(Format var1);

        public Builder registerEndpoints(Boolean var1);

        public Builder roleArn(String var1);

        public Builder s3Url(String var1);

        public Builder segmentId(String var1);

        public Builder segmentName(String var1);
    }
}

