/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.GPSCoordinatesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GPSCoordinates
implements StructuredPojo,
ToCopyableBuilder<Builder, GPSCoordinates> {
    private final Double latitude;
    private final Double longitude;

    private GPSCoordinates(BuilderImpl builder) {
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
    }

    public Double latitude() {
        return this.latitude;
    }

    public Double longitude() {
        return this.longitude;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.latitude());
        hashCode = 31 * hashCode + Objects.hashCode(this.longitude());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GPSCoordinates)) {
            return false;
        }
        GPSCoordinates other = (GPSCoordinates)obj;
        return Objects.equals(this.latitude(), other.latitude()) && Objects.equals(this.longitude(), other.longitude());
    }

    public String toString() {
        return ToString.builder((String)"GPSCoordinates").add("Latitude", (Object)this.latitude()).add("Longitude", (Object)this.longitude()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Latitude": {
                return Optional.ofNullable(clazz.cast(this.latitude()));
            }
            case "Longitude": {
                return Optional.ofNullable(clazz.cast(this.longitude()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GPSCoordinatesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Double latitude;
        private Double longitude;

        private BuilderImpl() {
        }

        private BuilderImpl(GPSCoordinates model) {
            this.latitude(model.latitude);
            this.longitude(model.longitude);
        }

        public final Double getLatitude() {
            return this.latitude;
        }

        @Override
        public final Builder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        public final void setLatitude(Double latitude) {
            this.latitude = latitude;
        }

        public final Double getLongitude() {
            return this.longitude;
        }

        @Override
        public final Builder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        public final void setLongitude(Double longitude) {
            this.longitude = longitude;
        }

        public GPSCoordinates build() {
            return new GPSCoordinates(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GPSCoordinates> {
        public Builder latitude(Double var1);

        public Builder longitude(Double var1);
    }
}

