/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.ItemResponse;
import software.amazon.awssdk.services.pinpoint.model.MapOfItemResponseCopier;
import software.amazon.awssdk.services.pinpoint.transform.EventsResponseMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventsResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, EventsResponse> {
    private final Map<String, ItemResponse> results;

    private EventsResponse(BuilderImpl builder) {
        this.results = builder.results;
    }

    public Map<String, ItemResponse> results() {
        return this.results;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.results());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventsResponse)) {
            return false;
        }
        EventsResponse other = (EventsResponse)obj;
        return Objects.equals(this.results(), other.results());
    }

    public String toString() {
        return ToString.builder((String)"EventsResponse").add("Results", this.results()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventsResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, ItemResponse> results = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventsResponse model) {
            this.results(model.results);
        }

        public final Map<String, ItemResponse.Builder> getResults() {
            return this.results != null ? CollectionUtils.mapValues(this.results, ItemResponse::toBuilder) : null;
        }

        @Override
        public final Builder results(Map<String, ItemResponse> results) {
            this.results = MapOfItemResponseCopier.copy(results);
            return this;
        }

        public final void setResults(Map<String, ItemResponse.BuilderImpl> results) {
            this.results = MapOfItemResponseCopier.copyFromBuilder(results);
        }

        public EventsResponse build() {
            return new EventsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventsResponse> {
        public Builder results(Map<String, ItemResponse> var1);
    }
}

