/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.EventsBatch;
import software.amazon.awssdk.services.pinpoint.model.MapOfEventsBatchCopier;
import software.amazon.awssdk.services.pinpoint.transform.EventsRequestMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventsRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, EventsRequest> {
    private final Map<String, EventsBatch> batchItem;

    private EventsRequest(BuilderImpl builder) {
        this.batchItem = builder.batchItem;
    }

    public Map<String, EventsBatch> batchItem() {
        return this.batchItem;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.batchItem());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventsRequest)) {
            return false;
        }
        EventsRequest other = (EventsRequest)obj;
        return Objects.equals(this.batchItem(), other.batchItem());
    }

    public String toString() {
        return ToString.builder((String)"EventsRequest").add("BatchItem", this.batchItem()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BatchItem": {
                return Optional.ofNullable(clazz.cast(this.batchItem()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventsRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, EventsBatch> batchItem = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventsRequest model) {
            this.batchItem(model.batchItem);
        }

        public final Map<String, EventsBatch.Builder> getBatchItem() {
            return this.batchItem != null ? CollectionUtils.mapValues(this.batchItem, EventsBatch::toBuilder) : null;
        }

        @Override
        public final Builder batchItem(Map<String, EventsBatch> batchItem) {
            this.batchItem = MapOfEventsBatchCopier.copy(batchItem);
            return this;
        }

        public final void setBatchItem(Map<String, EventsBatch.BuilderImpl> batchItem) {
            this.batchItem = MapOfEventsBatchCopier.copyFromBuilder(batchItem);
        }

        public EventsRequest build() {
            return new EventsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventsRequest> {
        public Builder batchItem(Map<String, EventsBatch> var1);
    }
}

