/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.MapOf__doubleCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.Session;
import software.amazon.awssdk.services.pinpoint.transform.EventMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Event
implements StructuredPojo,
ToCopyableBuilder<Builder, Event> {
    private final Map<String, String> attributes;
    private final String clientSdkVersion;
    private final String eventType;
    private final Map<String, Double> metrics;
    private final Session session;
    private final String timestamp;

    private Event(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.clientSdkVersion = builder.clientSdkVersion;
        this.eventType = builder.eventType;
        this.metrics = builder.metrics;
        this.session = builder.session;
        this.timestamp = builder.timestamp;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public String clientSdkVersion() {
        return this.clientSdkVersion;
    }

    public String eventType() {
        return this.eventType;
    }

    public Map<String, Double> metrics() {
        return this.metrics;
    }

    public Session session() {
        return this.session;
    }

    public String timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSdkVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventType());
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.session());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.clientSdkVersion(), other.clientSdkVersion()) && Objects.equals(this.eventType(), other.eventType()) && Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.session(), other.session()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public String toString() {
        return ToString.builder((String)"Event").add("Attributes", this.attributes()).add("ClientSdkVersion", (Object)this.clientSdkVersion()).add("EventType", (Object)this.eventType()).add("Metrics", this.metrics()).add("Session", (Object)this.session()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "ClientSdkVersion": {
                return Optional.ofNullable(clazz.cast(this.clientSdkVersion()));
            }
            case "EventType": {
                return Optional.ofNullable(clazz.cast(this.eventType()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "Session": {
                return Optional.ofNullable(clazz.cast(this.session()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String clientSdkVersion;
        private String eventType;
        private Map<String, Double> metrics = DefaultSdkAutoConstructMap.getInstance();
        private Session session;
        private String timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            this.attributes(model.attributes);
            this.clientSdkVersion(model.clientSdkVersion);
            this.eventType(model.eventType);
            this.metrics(model.metrics);
            this.session(model.session);
            this.timestamp(model.timestamp);
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapOf__stringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapOf__stringCopier.copy(attributes);
        }

        public final String getClientSdkVersion() {
            return this.clientSdkVersion;
        }

        @Override
        public final Builder clientSdkVersion(String clientSdkVersion) {
            this.clientSdkVersion = clientSdkVersion;
            return this;
        }

        public final void setClientSdkVersion(String clientSdkVersion) {
            this.clientSdkVersion = clientSdkVersion;
        }

        public final String getEventType() {
            return this.eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final Map<String, Double> getMetrics() {
            return this.metrics;
        }

        @Override
        public final Builder metrics(Map<String, Double> metrics) {
            this.metrics = MapOf__doubleCopier.copy(metrics);
            return this;
        }

        public final void setMetrics(Map<String, Double> metrics) {
            this.metrics = MapOf__doubleCopier.copy(metrics);
        }

        public final Session.Builder getSession() {
            return this.session != null ? this.session.toBuilder() : null;
        }

        @Override
        public final Builder session(Session session) {
            this.session = session;
            return this;
        }

        public final void setSession(Session.BuilderImpl session) {
            this.session = session != null ? session.build() : null;
        }

        public final String getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public Event build() {
            return new Event(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Event> {
        public Builder attributes(Map<String, String> var1);

        public Builder clientSdkVersion(String var1);

        public Builder eventType(String var1);

        public Builder metrics(Map<String, Double> var1);

        public Builder session(Session var1);

        default public Builder session(Consumer<Session.Builder> session) {
            return this.session((Session)((Session.Builder)Session.builder().applyMutation(session)).build());
        }

        public Builder timestamp(String var1);
    }
}

