/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.MapOfListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.transform.EndpointSendConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointSendConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, EndpointSendConfiguration> {
    private final String bodyOverride;
    private final Map<String, String> context;
    private final String rawContent;
    private final Map<String, List<String>> substitutions;
    private final String titleOverride;

    private EndpointSendConfiguration(BuilderImpl builder) {
        this.bodyOverride = builder.bodyOverride;
        this.context = builder.context;
        this.rawContent = builder.rawContent;
        this.substitutions = builder.substitutions;
        this.titleOverride = builder.titleOverride;
    }

    public String bodyOverride() {
        return this.bodyOverride;
    }

    public Map<String, String> context() {
        return this.context;
    }

    public String rawContent() {
        return this.rawContent;
    }

    public Map<String, List<String>> substitutions() {
        return this.substitutions;
    }

    public String titleOverride() {
        return this.titleOverride;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bodyOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.context());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.substitutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.titleOverride());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointSendConfiguration)) {
            return false;
        }
        EndpointSendConfiguration other = (EndpointSendConfiguration)obj;
        return Objects.equals(this.bodyOverride(), other.bodyOverride()) && Objects.equals(this.context(), other.context()) && Objects.equals(this.rawContent(), other.rawContent()) && Objects.equals(this.substitutions(), other.substitutions()) && Objects.equals(this.titleOverride(), other.titleOverride());
    }

    public String toString() {
        return ToString.builder((String)"EndpointSendConfiguration").add("BodyOverride", (Object)this.bodyOverride()).add("Context", this.context()).add("RawContent", (Object)this.rawContent()).add("Substitutions", this.substitutions()).add("TitleOverride", (Object)this.titleOverride()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BodyOverride": {
                return Optional.ofNullable(clazz.cast(this.bodyOverride()));
            }
            case "Context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
            case "RawContent": {
                return Optional.ofNullable(clazz.cast(this.rawContent()));
            }
            case "Substitutions": {
                return Optional.ofNullable(clazz.cast(this.substitutions()));
            }
            case "TitleOverride": {
                return Optional.ofNullable(clazz.cast(this.titleOverride()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointSendConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String bodyOverride;
        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();
        private String rawContent;
        private Map<String, List<String>> substitutions = DefaultSdkAutoConstructMap.getInstance();
        private String titleOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointSendConfiguration model) {
            this.bodyOverride(model.bodyOverride);
            this.context(model.context);
            this.rawContent(model.rawContent);
            this.substitutions(model.substitutions);
            this.titleOverride(model.titleOverride);
        }

        public final String getBodyOverride() {
            return this.bodyOverride;
        }

        @Override
        public final Builder bodyOverride(String bodyOverride) {
            this.bodyOverride = bodyOverride;
            return this;
        }

        public final void setBodyOverride(String bodyOverride) {
            this.bodyOverride = bodyOverride;
        }

        public final Map<String, String> getContext() {
            return this.context;
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
            return this;
        }

        public final void setContext(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
        }

        public final String getRawContent() {
            return this.rawContent;
        }

        @Override
        public final Builder rawContent(String rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        public final void setRawContent(String rawContent) {
            this.rawContent = rawContent;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            return this.substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        public final String getTitleOverride() {
            return this.titleOverride;
        }

        @Override
        public final Builder titleOverride(String titleOverride) {
            this.titleOverride = titleOverride;
            return this;
        }

        public final void setTitleOverride(String titleOverride) {
            this.titleOverride = titleOverride;
        }

        public EndpointSendConfiguration build() {
            return new EndpointSendConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EndpointSendConfiguration> {
        public Builder bodyOverride(String var1);

        public Builder context(Map<String, String> var1);

        public Builder rawContent(String var1);

        public Builder substitutions(Map<String, ? extends Collection<String>> var1);

        public Builder titleOverride(String var1);
    }
}

