/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.EndpointDemographicMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointDemographic
implements StructuredPojo,
ToCopyableBuilder<Builder, EndpointDemographic> {
    private final String appVersion;
    private final String locale;
    private final String make;
    private final String model;
    private final String modelVersion;
    private final String platform;
    private final String platformVersion;
    private final String timezone;

    private EndpointDemographic(BuilderImpl builder) {
        this.appVersion = builder.appVersion;
        this.locale = builder.locale;
        this.make = builder.make;
        this.model = builder.model;
        this.modelVersion = builder.modelVersion;
        this.platform = builder.platform;
        this.platformVersion = builder.platformVersion;
        this.timezone = builder.timezone;
    }

    public String appVersion() {
        return this.appVersion;
    }

    public String locale() {
        return this.locale;
    }

    public String make() {
        return this.make;
    }

    public String model() {
        return this.model;
    }

    public String modelVersion() {
        return this.modelVersion;
    }

    public String platform() {
        return this.platform;
    }

    public String platformVersion() {
        return this.platformVersion;
    }

    public String timezone() {
        return this.timezone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        hashCode = 31 * hashCode + Objects.hashCode(this.make());
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointDemographic)) {
            return false;
        }
        EndpointDemographic other = (EndpointDemographic)obj;
        return Objects.equals(this.appVersion(), other.appVersion()) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.make(), other.make()) && Objects.equals(this.model(), other.model()) && Objects.equals(this.modelVersion(), other.modelVersion()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.timezone(), other.timezone());
    }

    public String toString() {
        return ToString.builder((String)"EndpointDemographic").add("AppVersion", (Object)this.appVersion()).add("Locale", (Object)this.locale()).add("Make", (Object)this.make()).add("Model", (Object)this.model()).add("ModelVersion", (Object)this.modelVersion()).add("Platform", (Object)this.platform()).add("PlatformVersion", (Object)this.platformVersion()).add("Timezone", (Object)this.timezone()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppVersion": {
                return Optional.ofNullable(clazz.cast(this.appVersion()));
            }
            case "Locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
            case "Make": {
                return Optional.ofNullable(clazz.cast(this.make()));
            }
            case "Model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "ModelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "PlatformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "Timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointDemographicMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String appVersion;
        private String locale;
        private String make;
        private String model;
        private String modelVersion;
        private String platform;
        private String platformVersion;
        private String timezone;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointDemographic model) {
            this.appVersion(model.appVersion);
            this.locale(model.locale);
            this.make(model.make);
            this.model(model.model);
            this.modelVersion(model.modelVersion);
            this.platform(model.platform);
            this.platformVersion(model.platformVersion);
            this.timezone(model.timezone);
        }

        public final String getAppVersion() {
            return this.appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        public final String getLocale() {
            return this.locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final String getMake() {
            return this.make;
        }

        @Override
        public final Builder make(String make) {
            this.make = make;
            return this;
        }

        public final void setMake(String make) {
            this.make = make;
        }

        public final String getModel() {
            return this.model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        public final String getModelVersion() {
            return this.modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public EndpointDemographic build() {
            return new EndpointDemographic(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EndpointDemographic> {
        public Builder appVersion(String var1);

        public Builder locale(String var1);

        public Builder make(String var1);

        public Builder model(String var1);

        public Builder modelVersion(String var1);

        public Builder platform(String var1);

        public Builder platformVersion(String var1);

        public Builder timezone(String var1);
    }
}

