/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.MapOfListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.transform.DefaultMessageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DefaultMessage
implements StructuredPojo,
ToCopyableBuilder<Builder, DefaultMessage> {
    private final String body;
    private final Map<String, List<String>> substitutions;

    private DefaultMessage(BuilderImpl builder) {
        this.body = builder.body;
        this.substitutions = builder.substitutions;
    }

    public String body() {
        return this.body;
    }

    public Map<String, List<String>> substitutions() {
        return this.substitutions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.substitutions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultMessage)) {
            return false;
        }
        DefaultMessage other = (DefaultMessage)obj;
        return Objects.equals(this.body(), other.body()) && Objects.equals(this.substitutions(), other.substitutions());
    }

    public String toString() {
        return ToString.builder((String)"DefaultMessage").add("Body", (Object)this.body()).add("Substitutions", this.substitutions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "Substitutions": {
                return Optional.ofNullable(clazz.cast(this.substitutions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DefaultMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String body;
        private Map<String, List<String>> substitutions = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultMessage model) {
            this.body(model.body);
            this.substitutions(model.substitutions);
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            return this.substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        public DefaultMessage build() {
            return new DefaultMessage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DefaultMessage> {
        public Builder body(String var1);

        public Builder substitutions(Map<String, ? extends Collection<String>> var1);
    }
}

