/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.pinpoint.model.ExportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateExportJobRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, CreateExportJobRequest> {
    private final String applicationId;
    private final ExportJobRequest exportJobRequest;

    private CreateExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.exportJobRequest = builder.exportJobRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public ExportJobRequest exportJobRequest() {
        return this.exportJobRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportJobRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExportJobRequest)) {
            return false;
        }
        CreateExportJobRequest other = (CreateExportJobRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.exportJobRequest(), other.exportJobRequest());
    }

    public String toString() {
        return ToString.builder((String)"CreateExportJobRequest").add("ApplicationId", (Object)this.applicationId()).add("ExportJobRequest", (Object)this.exportJobRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "ExportJobRequest": {
                return Optional.ofNullable(clazz.cast(this.exportJobRequest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private ExportJobRequest exportJobRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExportJobRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.exportJobRequest(model.exportJobRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final ExportJobRequest.Builder getExportJobRequest() {
            return this.exportJobRequest != null ? this.exportJobRequest.toBuilder() : null;
        }

        @Override
        public final Builder exportJobRequest(ExportJobRequest exportJobRequest) {
            this.exportJobRequest = exportJobRequest;
            return this;
        }

        public final void setExportJobRequest(ExportJobRequest.BuilderImpl exportJobRequest) {
            this.exportJobRequest = exportJobRequest != null ? exportJobRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExportJobRequest build() {
            return new CreateExportJobRequest(this);
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    CopyableBuilder<Builder, CreateExportJobRequest> {
        public Builder applicationId(String var1);

        public Builder exportJobRequest(ExportJobRequest var1);

        default public Builder exportJobRequest(Consumer<ExportJobRequest.Builder> exportJobRequest) {
            return this.exportJobRequest((ExportJobRequest)((ExportJobRequest.Builder)ExportJobRequest.builder().applyMutation(exportJobRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

