/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.ChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.MapOfChannelResponseCopier;
import software.amazon.awssdk.services.pinpoint.transform.ChannelsResponseMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChannelsResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, ChannelsResponse> {
    private final Map<String, ChannelResponse> channels;

    private ChannelsResponse(BuilderImpl builder) {
        this.channels = builder.channels;
    }

    public Map<String, ChannelResponse> channels() {
        return this.channels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channels());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelsResponse)) {
            return false;
        }
        ChannelsResponse other = (ChannelsResponse)obj;
        return Objects.equals(this.channels(), other.channels());
    }

    public String toString() {
        return ToString.builder((String)"ChannelsResponse").add("Channels", this.channels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ChannelsResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, ChannelResponse> channels = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelsResponse model) {
            this.channels(model.channels);
        }

        public final Map<String, ChannelResponse.Builder> getChannels() {
            return this.channels != null ? CollectionUtils.mapValues(this.channels, ChannelResponse::toBuilder) : null;
        }

        @Override
        public final Builder channels(Map<String, ChannelResponse> channels) {
            this.channels = MapOfChannelResponseCopier.copy(channels);
            return this;
        }

        public final void setChannels(Map<String, ChannelResponse.BuilderImpl> channels) {
            this.channels = MapOfChannelResponseCopier.copyFromBuilder(channels);
        }

        public ChannelsResponse build() {
            return new ChannelsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ChannelsResponse> {
        public Builder channels(Map<String, ChannelResponse> var1);
    }
}

