/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.Mode;
import software.amazon.awssdk.services.pinpoint.transform.CampaignHookMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CampaignHook
implements StructuredPojo,
ToCopyableBuilder<Builder, CampaignHook> {
    private final String lambdaFunctionName;
    private final String mode;
    private final String webUrl;

    private CampaignHook(BuilderImpl builder) {
        this.lambdaFunctionName = builder.lambdaFunctionName;
        this.mode = builder.mode;
        this.webUrl = builder.webUrl;
    }

    public String lambdaFunctionName() {
        return this.lambdaFunctionName;
    }

    public Mode mode() {
        return Mode.fromValue(this.mode);
    }

    public String modeAsString() {
        return this.mode;
    }

    public String webUrl() {
        return this.webUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.webUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignHook)) {
            return false;
        }
        CampaignHook other = (CampaignHook)obj;
        return Objects.equals(this.lambdaFunctionName(), other.lambdaFunctionName()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.webUrl(), other.webUrl());
    }

    public String toString() {
        return ToString.builder((String)"CampaignHook").add("LambdaFunctionName", (Object)this.lambdaFunctionName()).add("Mode", (Object)this.modeAsString()).add("WebUrl", (Object)this.webUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LambdaFunctionName": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionName()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "WebUrl": {
                return Optional.ofNullable(clazz.cast(this.webUrl()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CampaignHookMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String lambdaFunctionName;
        private String mode;
        private String webUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignHook model) {
            this.lambdaFunctionName(model.lambdaFunctionName);
            this.mode(model.mode);
            this.webUrl(model.webUrl);
        }

        public final String getLambdaFunctionName() {
            return this.lambdaFunctionName;
        }

        @Override
        public final Builder lambdaFunctionName(String lambdaFunctionName) {
            this.lambdaFunctionName = lambdaFunctionName;
            return this;
        }

        public final void setLambdaFunctionName(String lambdaFunctionName) {
            this.lambdaFunctionName = lambdaFunctionName;
        }

        public final String getMode() {
            return this.mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(Mode mode) {
            this.mode(mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public final String getWebUrl() {
            return this.webUrl;
        }

        @Override
        public final Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            return this;
        }

        public final void setWebUrl(String webUrl) {
            this.webUrl = webUrl;
        }

        public CampaignHook build() {
            return new CampaignHook(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CampaignHook> {
        public Builder lambdaFunctionName(String var1);

        public Builder mode(String var1);

        public Builder mode(Mode var1);

        public Builder webUrl(String var1);
    }
}

