/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.ActivityResponse;
import software.amazon.awssdk.services.pinpoint.model.ListOfActivityResponseCopier;
import software.amazon.awssdk.services.pinpoint.transform.ActivitiesResponseMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActivitiesResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, ActivitiesResponse> {
    private final List<ActivityResponse> item;
    private final String nextToken;

    private ActivitiesResponse(BuilderImpl builder) {
        this.item = builder.item;
        this.nextToken = builder.nextToken;
    }

    public List<ActivityResponse> item() {
        return this.item;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.item());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivitiesResponse)) {
            return false;
        }
        ActivitiesResponse other = (ActivitiesResponse)obj;
        return Objects.equals(this.item(), other.item()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ActivitiesResponse").add("Item", this.item()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Item": {
                return Optional.ofNullable(clazz.cast(this.item()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActivitiesResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ActivityResponse> item = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivitiesResponse model) {
            this.item(model.item);
            this.nextToken(model.nextToken);
        }

        public final Collection<ActivityResponse.Builder> getItem() {
            return this.item != null ? (Collection)this.item.stream().map(ActivityResponse::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder item(Collection<ActivityResponse> item) {
            this.item = ListOfActivityResponseCopier.copy(item);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(ActivityResponse ... item) {
            this.item(Arrays.asList(item));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(Consumer<ActivityResponse.Builder> ... item) {
            this.item(Stream.of(item).map(c -> (ActivityResponse)((ActivityResponse.Builder)ActivityResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItem(Collection<ActivityResponse.BuilderImpl> item) {
            this.item = ListOfActivityResponseCopier.copyFromBuilder(item);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ActivitiesResponse build() {
            return new ActivitiesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ActivitiesResponse> {
        public Builder item(Collection<ActivityResponse> var1);

        public Builder item(ActivityResponse ... var1);

        public Builder item(Consumer<ActivityResponse.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

