/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.WriteSegmentRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class WriteSegmentRequestMarshaller {
    private static final MarshallingInfo<StructuredPojo> DIMENSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Dimensions").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final WriteSegmentRequestMarshaller INSTANCE = new WriteSegmentRequestMarshaller();

    private WriteSegmentRequestMarshaller() {
    }

    public static WriteSegmentRequestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(WriteSegmentRequest writeSegmentRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)writeSegmentRequest, (String)"writeSegmentRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)writeSegmentRequest.dimensions(), DIMENSIONS_BINDING);
            protocolMarshaller.marshall((Object)writeSegmentRequest.name(), NAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

