/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.GCMChannelRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GCMChannelRequestMarshaller {
    private static final MarshallingInfo<String> APIKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApiKey").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();
    private static final GCMChannelRequestMarshaller INSTANCE = new GCMChannelRequestMarshaller();

    private GCMChannelRequestMarshaller() {
    }

    public static GCMChannelRequestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GCMChannelRequest gcmChannelRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)gcmChannelRequest, (String)"gcmChannelRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)gcmChannelRequest.apiKey(), APIKEY_BINDING);
            protocolMarshaller.marshall((Object)gcmChannelRequest.enabled(), ENABLED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

