/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.pinpoint.model.APNSChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApnsChannelRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateApnsChannelRequest> {
    private final APNSChannelRequest apnsChannelRequest;
    private final String applicationId;

    private UpdateApnsChannelRequest(BuilderImpl builder) {
        super(builder);
        this.apnsChannelRequest = builder.apnsChannelRequest;
        this.applicationId = builder.applicationId;
    }

    public APNSChannelRequest apnsChannelRequest() {
        return this.apnsChannelRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apnsChannelRequest());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApnsChannelRequest)) {
            return false;
        }
        UpdateApnsChannelRequest other = (UpdateApnsChannelRequest)((Object)obj);
        return Objects.equals(this.apnsChannelRequest(), other.apnsChannelRequest()) && Objects.equals(this.applicationId(), other.applicationId());
    }

    public String toString() {
        return ToString.builder((String)"UpdateApnsChannelRequest").add("APNSChannelRequest", (Object)this.apnsChannelRequest()).add("ApplicationId", (Object)this.applicationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "APNSChannelRequest": {
                return Optional.ofNullable(clazz.cast(this.apnsChannelRequest()));
            }
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private APNSChannelRequest apnsChannelRequest;
        private String applicationId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApnsChannelRequest model) {
            super(model);
            this.apnsChannelRequest(model.apnsChannelRequest);
            this.applicationId(model.applicationId);
        }

        public final APNSChannelRequest.Builder getAPNSChannelRequest() {
            return this.apnsChannelRequest != null ? this.apnsChannelRequest.toBuilder() : null;
        }

        @Override
        public final Builder apnsChannelRequest(APNSChannelRequest apnsChannelRequest) {
            this.apnsChannelRequest = apnsChannelRequest;
            return this;
        }

        public final void setAPNSChannelRequest(APNSChannelRequest.BuilderImpl apnsChannelRequest) {
            this.apnsChannelRequest = apnsChannelRequest != null ? apnsChannelRequest.build() : null;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApnsChannelRequest build() {
            return new UpdateApnsChannelRequest(this);
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    CopyableBuilder<Builder, UpdateApnsChannelRequest> {
        public Builder apnsChannelRequest(APNSChannelRequest var1);

        default public Builder apnsChannelRequest(Consumer<APNSChannelRequest.Builder> apnsChannelRequest) {
            return this.apnsChannelRequest((APNSChannelRequest)((APNSChannelRequest.Builder)APNSChannelRequest.builder().applyMutation(apnsChannelRequest)).build());
        }

        public Builder applicationId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

