/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.pinpoint.model.ImportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateImportJobRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, CreateImportJobRequest> {
    private final String applicationId;
    private final ImportJobRequest importJobRequest;

    private CreateImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.importJobRequest = builder.importJobRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public ImportJobRequest importJobRequest() {
        return this.importJobRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.importJobRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImportJobRequest)) {
            return false;
        }
        CreateImportJobRequest other = (CreateImportJobRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.importJobRequest(), other.importJobRequest());
    }

    public String toString() {
        return ToString.builder((String)"CreateImportJobRequest").add("ApplicationId", (Object)this.applicationId()).add("ImportJobRequest", (Object)this.importJobRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "ImportJobRequest": {
                return Optional.ofNullable(clazz.cast(this.importJobRequest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private ImportJobRequest importJobRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImportJobRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.importJobRequest(model.importJobRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final ImportJobRequest.Builder getImportJobRequest() {
            return this.importJobRequest != null ? this.importJobRequest.toBuilder() : null;
        }

        @Override
        public final Builder importJobRequest(ImportJobRequest importJobRequest) {
            this.importJobRequest = importJobRequest;
            return this;
        }

        public final void setImportJobRequest(ImportJobRequest.BuilderImpl importJobRequest) {
            this.importJobRequest = importJobRequest != null ? importJobRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateImportJobRequest build() {
            return new CreateImportJobRequest(this);
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    CopyableBuilder<Builder, CreateImportJobRequest> {
        public Builder applicationId(String var1);

        public Builder importJobRequest(ImportJobRequest var1);

        default public Builder importJobRequest(Consumer<ImportJobRequest.Builder> importJobRequest) {
            return this.importJobRequest((ImportJobRequest)((ImportJobRequest.Builder)ImportJobRequest.builder().applyMutation(importJobRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

