/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.QuietTime;

public class QuietTimeUnmarshaller
implements Unmarshaller<QuietTime, JsonUnmarshallerContext> {
    private static final QuietTimeUnmarshaller INSTANCE = new QuietTimeUnmarshaller();

    public QuietTime unmarshall(JsonUnmarshallerContext context) throws Exception {
        QuietTime.Builder quietTimeBuilder = QuietTime.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("End", targetDepth)) {
                    context.nextToken();
                    quietTimeBuilder.end((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Start", targetDepth)) {
                    context.nextToken();
                    quietTimeBuilder.start((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (QuietTime)quietTimeBuilder.build();
    }

    public static QuietTimeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

