/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.GetEndpointRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetEndpointRequestModelMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("application-id").isBinary(false).build();
    private static final MarshallingInfo<String> ENDPOINTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("endpoint-id").isBinary(false).build();
    private static final GetEndpointRequestModelMarshaller INSTANCE = new GetEndpointRequestModelMarshaller();

    private GetEndpointRequestModelMarshaller() {
    }

    public static GetEndpointRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetEndpointRequest getEndpointRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getEndpointRequest), (String)"getEndpointRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getEndpointRequest.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)getEndpointRequest.endpointId(), ENDPOINTID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

