/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.EndpointResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EndpointResponseMarshaller {
    private static final MarshallingInfo<String> ADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Address").isBinary(false).build();
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationId").isBinary(false).build();
    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").isBinary(false).build();
    private static final MarshallingInfo<String> CHANNELTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChannelType").isBinary(false).build();
    private static final MarshallingInfo<String> COHORTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CohortId").isBinary(false).build();
    private static final MarshallingInfo<String> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DEMOGRAPHIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Demographic").isBinary(false).build();
    private static final MarshallingInfo<String> EFFECTIVEDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EffectiveDate").isBinary(false).build();
    private static final MarshallingInfo<String> ENDPOINTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointStatus").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Location").isBinary(false).build();
    private static final MarshallingInfo<Map> METRICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Metrics").isBinary(false).build();
    private static final MarshallingInfo<String> OPTOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OptOut").isBinary(false).build();
    private static final MarshallingInfo<String> REQUESTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> USER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("User").isBinary(false).build();
    private static final EndpointResponseMarshaller INSTANCE = new EndpointResponseMarshaller();

    private EndpointResponseMarshaller() {
    }

    public static EndpointResponseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EndpointResponse endpointResponse, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)endpointResponse, (String)"endpointResponse");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)endpointResponse.address(), ADDRESS_BINDING);
            protocolMarshaller.marshall((Object)endpointResponse.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall(endpointResponse.attributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)endpointResponse.channelTypeAsString(), CHANNELTYPE_BINDING);
            protocolMarshaller.marshall((Object)endpointResponse.cohortId(), COHORTID_BINDING);
            protocolMarshaller.marshall((Object)endpointResponse.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)endpointResponse.demographic(), DEMOGRAPHIC_BINDING);
            protocolMarshaller.marshall((Object)endpointResponse.effectiveDate(), EFFECTIVEDATE_BINDING);
            protocolMarshaller.marshall((Object)endpointResponse.endpointStatus(), ENDPOINTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)endpointResponse.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)endpointResponse.location(), LOCATION_BINDING);
            protocolMarshaller.marshall(endpointResponse.metrics(), METRICS_BINDING);
            protocolMarshaller.marshall((Object)endpointResponse.optOut(), OPTOUT_BINDING);
            protocolMarshaller.marshall((Object)endpointResponse.requestId(), REQUESTID_BINDING);
            protocolMarshaller.marshall((Object)endpointResponse.user(), USER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

