/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.APNSChannelRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class APNSChannelRequestMarshaller {
    private static final MarshallingInfo<String> BUNDLEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BundleId").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Certificate").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTAUTHENTICATIONMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultAuthenticationMethod").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();
    private static final MarshallingInfo<String> PRIVATEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivateKey").isBinary(false).build();
    private static final MarshallingInfo<String> TEAMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TeamId").isBinary(false).build();
    private static final MarshallingInfo<String> TOKENKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TokenKey").isBinary(false).build();
    private static final MarshallingInfo<String> TOKENKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TokenKeyId").isBinary(false).build();
    private static final APNSChannelRequestMarshaller INSTANCE = new APNSChannelRequestMarshaller();

    private APNSChannelRequestMarshaller() {
    }

    public static APNSChannelRequestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(APNSChannelRequest apnsChannelRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)apnsChannelRequest, (String)"apnsChannelRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)apnsChannelRequest.bundleId(), BUNDLEID_BINDING);
            protocolMarshaller.marshall((Object)apnsChannelRequest.certificate(), CERTIFICATE_BINDING);
            protocolMarshaller.marshall((Object)apnsChannelRequest.defaultAuthenticationMethod(), DEFAULTAUTHENTICATIONMETHOD_BINDING);
            protocolMarshaller.marshall((Object)apnsChannelRequest.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)apnsChannelRequest.privateKey(), PRIVATEKEY_BINDING);
            protocolMarshaller.marshall((Object)apnsChannelRequest.teamId(), TEAMID_BINDING);
            protocolMarshaller.marshall((Object)apnsChannelRequest.tokenKey(), TOKENKEY_BINDING);
            protocolMarshaller.marshall((Object)apnsChannelRequest.tokenKeyId(), TOKENKEYID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

