/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.pinpoint.model.ADMChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateAdmChannelRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateAdmChannelRequest> {
    private final ADMChannelRequest admChannelRequest;
    private final String applicationId;

    private UpdateAdmChannelRequest(BuilderImpl builder) {
        super(builder);
        this.admChannelRequest = builder.admChannelRequest;
        this.applicationId = builder.applicationId;
    }

    public ADMChannelRequest admChannelRequest() {
        return this.admChannelRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.admChannelRequest());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAdmChannelRequest)) {
            return false;
        }
        UpdateAdmChannelRequest other = (UpdateAdmChannelRequest)((Object)obj);
        return Objects.equals(this.admChannelRequest(), other.admChannelRequest()) && Objects.equals(this.applicationId(), other.applicationId());
    }

    public String toString() {
        return ToString.builder((String)"UpdateAdmChannelRequest").add("ADMChannelRequest", (Object)this.admChannelRequest()).add("ApplicationId", (Object)this.applicationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ADMChannelRequest": {
                return Optional.of(clazz.cast(this.admChannelRequest()));
            }
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private ADMChannelRequest admChannelRequest;
        private String applicationId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAdmChannelRequest model) {
            super(model);
            this.admChannelRequest(model.admChannelRequest);
            this.applicationId(model.applicationId);
        }

        public final ADMChannelRequest.Builder getADMChannelRequest() {
            return this.admChannelRequest != null ? this.admChannelRequest.toBuilder() : null;
        }

        @Override
        public final Builder admChannelRequest(ADMChannelRequest admChannelRequest) {
            this.admChannelRequest = admChannelRequest;
            return this;
        }

        public final void setADMChannelRequest(ADMChannelRequest.BuilderImpl admChannelRequest) {
            this.admChannelRequest = admChannelRequest != null ? admChannelRequest.build() : null;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateAdmChannelRequest build() {
            return new UpdateAdmChannelRequest(this);
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    CopyableBuilder<Builder, UpdateAdmChannelRequest> {
        public Builder admChannelRequest(ADMChannelRequest var1);

        default public Builder admChannelRequest(Consumer<ADMChannelRequest.Builder> admChannelRequest) {
            return this.admChannelRequest((ADMChannelRequest)((ADMChannelRequest.Builder)ADMChannelRequest.builder().apply(admChannelRequest)).build());
        }

        public Builder applicationId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

