/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.DimensionType;
import software.amazon.awssdk.services.pinpoint.model.ListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.transform.SetDimensionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetDimension
implements StructuredPojo,
ToCopyableBuilder<Builder, SetDimension> {
    private final String dimensionType;
    private final List<String> values;

    private SetDimension(BuilderImpl builder) {
        this.dimensionType = builder.dimensionType;
        this.values = builder.values;
    }

    public DimensionType dimensionType() {
        return DimensionType.fromValue(this.dimensionType);
    }

    public String dimensionTypeAsString() {
        return this.dimensionType;
    }

    public List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetDimension)) {
            return false;
        }
        SetDimension other = (SetDimension)obj;
        return Objects.equals(this.dimensionTypeAsString(), other.dimensionTypeAsString()) && Objects.equals(this.values(), other.values());
    }

    public String toString() {
        return ToString.builder((String)"SetDimension").add("DimensionType", (Object)this.dimensionTypeAsString()).add("Values", this.values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DimensionType": {
                return Optional.of(clazz.cast(this.dimensionTypeAsString()));
            }
            case "Values": {
                return Optional.of(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SetDimensionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String dimensionType;
        private List<String> values;

        private BuilderImpl() {
        }

        private BuilderImpl(SetDimension model) {
            this.dimensionType(model.dimensionType);
            this.values(model.values);
        }

        public final String getDimensionType() {
            return this.dimensionType;
        }

        @Override
        public final Builder dimensionType(String dimensionType) {
            this.dimensionType = dimensionType;
            return this;
        }

        @Override
        public final Builder dimensionType(DimensionType dimensionType) {
            this.dimensionType(dimensionType.toString());
            return this;
        }

        public final void setDimensionType(String dimensionType) {
            this.dimensionType = dimensionType;
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ListOf__stringCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ListOf__stringCopier.copy(values);
        }

        public SetDimension build() {
            return new SetDimension(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetDimension> {
        public Builder dimensionType(String var1);

        public Builder dimensionType(DimensionType var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

