/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.GCMChannelRequestMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GCMChannelRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, GCMChannelRequest> {
    private final String apiKey;
    private final Boolean enabled;

    private GCMChannelRequest(BuilderImpl builder) {
        this.apiKey = builder.apiKey;
        this.enabled = builder.enabled;
    }

    public String apiKey() {
        return this.apiKey;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GCMChannelRequest)) {
            return false;
        }
        GCMChannelRequest other = (GCMChannelRequest)obj;
        return Objects.equals(this.apiKey(), other.apiKey()) && Objects.equals(this.enabled(), other.enabled());
    }

    public String toString() {
        return ToString.builder((String)"GCMChannelRequest").add("ApiKey", (Object)this.apiKey()).add("Enabled", (Object)this.enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiKey": {
                return Optional.of(clazz.cast(this.apiKey()));
            }
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GCMChannelRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String apiKey;
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(GCMChannelRequest model) {
            this.apiKey(model.apiKey);
            this.enabled(model.enabled);
        }

        public final String getApiKey() {
            return this.apiKey;
        }

        @Override
        public final Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public GCMChannelRequest build() {
            return new GCMChannelRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GCMChannelRequest> {
        public Builder apiKey(String var1);

        public Builder enabled(Boolean var1);
    }
}

