/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.CampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.ListOfCampaignResponseCopier;
import software.amazon.awssdk.services.pinpoint.transform.CampaignsResponseMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CampaignsResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, CampaignsResponse> {
    private final List<CampaignResponse> item;
    private final String nextToken;

    private CampaignsResponse(BuilderImpl builder) {
        this.item = builder.item;
        this.nextToken = builder.nextToken;
    }

    public List<CampaignResponse> item() {
        return this.item;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.item());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignsResponse)) {
            return false;
        }
        CampaignsResponse other = (CampaignsResponse)obj;
        return Objects.equals(this.item(), other.item()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"CampaignsResponse").add("Item", this.item()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Item": {
                return Optional.of(clazz.cast(this.item()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CampaignsResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CampaignResponse> item;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignsResponse model) {
            this.item(model.item);
            this.nextToken(model.nextToken);
        }

        public final Collection<CampaignResponse.Builder> getItem() {
            return this.item != null ? (Collection)this.item.stream().map(CampaignResponse::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder item(Collection<CampaignResponse> item) {
            this.item = ListOfCampaignResponseCopier.copy(item);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(CampaignResponse ... item) {
            this.item(Arrays.asList(item));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(Consumer<CampaignResponse.Builder> ... item) {
            this.item(Stream.of(item).map(c -> (CampaignResponse)((CampaignResponse.Builder)CampaignResponse.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItem(Collection<CampaignResponse.BuilderImpl> item) {
            this.item = ListOfCampaignResponseCopier.copyFromBuilder(item);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public CampaignsResponse build() {
            return new CampaignsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CampaignsResponse> {
        public Builder item(Collection<CampaignResponse> var1);

        public Builder item(CampaignResponse ... var1);

        public Builder item(Consumer<CampaignResponse.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

