/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.CampaignLimits;
import software.amazon.awssdk.services.pinpoint.model.QuietTime;
import software.amazon.awssdk.services.pinpoint.transform.ApplicationSettingsResourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApplicationSettingsResource
implements StructuredPojo,
ToCopyableBuilder<Builder, ApplicationSettingsResource> {
    private final String applicationId;
    private final String lastModifiedDate;
    private final CampaignLimits limits;
    private final QuietTime quietTime;

    private ApplicationSettingsResource(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.limits = builder.limits;
        this.quietTime = builder.quietTime;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public CampaignLimits limits() {
        return this.limits;
    }

    public QuietTime quietTime() {
        return this.quietTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.limits());
        hashCode = 31 * hashCode + Objects.hashCode(this.quietTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSettingsResource)) {
            return false;
        }
        ApplicationSettingsResource other = (ApplicationSettingsResource)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.limits(), other.limits()) && Objects.equals(this.quietTime(), other.quietTime());
    }

    public String toString() {
        return ToString.builder((String)"ApplicationSettingsResource").add("ApplicationId", (Object)this.applicationId()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("Limits", (Object)this.limits()).add("QuietTime", (Object)this.quietTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "LastModifiedDate": {
                return Optional.of(clazz.cast(this.lastModifiedDate()));
            }
            case "Limits": {
                return Optional.of(clazz.cast(this.limits()));
            }
            case "QuietTime": {
                return Optional.of(clazz.cast(this.quietTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationSettingsResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String lastModifiedDate;
        private CampaignLimits limits;
        private QuietTime quietTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSettingsResource model) {
            this.applicationId(model.applicationId);
            this.lastModifiedDate(model.lastModifiedDate);
            this.limits(model.limits);
            this.quietTime(model.quietTime);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final CampaignLimits.Builder getLimits() {
            return this.limits != null ? this.limits.toBuilder() : null;
        }

        @Override
        public final Builder limits(CampaignLimits limits) {
            this.limits = limits;
            return this;
        }

        public final void setLimits(CampaignLimits.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        public final QuietTime.Builder getQuietTime() {
            return this.quietTime != null ? this.quietTime.toBuilder() : null;
        }

        @Override
        public final Builder quietTime(QuietTime quietTime) {
            this.quietTime = quietTime;
            return this;
        }

        public final void setQuietTime(QuietTime.BuilderImpl quietTime) {
            this.quietTime = quietTime != null ? quietTime.build() : null;
        }

        public ApplicationSettingsResource build() {
            return new ApplicationSettingsResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplicationSettingsResource> {
        public Builder applicationId(String var1);

        public Builder lastModifiedDate(String var1);

        public Builder limits(CampaignLimits var1);

        default public Builder limits(Consumer<CampaignLimits.Builder> limits) {
            return this.limits((CampaignLimits)((CampaignLimits.Builder)CampaignLimits.builder().apply(limits)).build());
        }

        public Builder quietTime(QuietTime var1);

        default public Builder quietTime(Consumer<QuietTime.Builder> quietTime) {
            return this.quietTime((QuietTime)((QuietTime.Builder)QuietTime.builder().apply(quietTime)).build());
        }
    }
}

