/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.Action;
import software.amazon.awssdk.services.pinpoint.model.MapOfListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.transform.APNSMessageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class APNSMessage
implements StructuredPojo,
ToCopyableBuilder<Builder, APNSMessage> {
    private final String action;
    private final Integer badge;
    private final String body;
    private final String category;
    private final String collapseId;
    private final Map<String, String> data;
    private final String mediaUrl;
    private final String preferredAuthenticationMethod;
    private final String priority;
    private final String rawContent;
    private final Boolean silentPush;
    private final String sound;
    private final Map<String, List<String>> substitutions;
    private final String threadId;
    private final Integer timeToLive;
    private final String title;
    private final String url;

    private APNSMessage(BuilderImpl builder) {
        this.action = builder.action;
        this.badge = builder.badge;
        this.body = builder.body;
        this.category = builder.category;
        this.collapseId = builder.collapseId;
        this.data = builder.data;
        this.mediaUrl = builder.mediaUrl;
        this.preferredAuthenticationMethod = builder.preferredAuthenticationMethod;
        this.priority = builder.priority;
        this.rawContent = builder.rawContent;
        this.silentPush = builder.silentPush;
        this.sound = builder.sound;
        this.substitutions = builder.substitutions;
        this.threadId = builder.threadId;
        this.timeToLive = builder.timeToLive;
        this.title = builder.title;
        this.url = builder.url;
    }

    public Action action() {
        return Action.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public Integer badge() {
        return this.badge;
    }

    public String body() {
        return this.body;
    }

    public String category() {
        return this.category;
    }

    public String collapseId() {
        return this.collapseId;
    }

    public Map<String, String> data() {
        return this.data;
    }

    public String mediaUrl() {
        return this.mediaUrl;
    }

    public String preferredAuthenticationMethod() {
        return this.preferredAuthenticationMethod;
    }

    public String priority() {
        return this.priority;
    }

    public String rawContent() {
        return this.rawContent;
    }

    public Boolean silentPush() {
        return this.silentPush;
    }

    public String sound() {
        return this.sound;
    }

    public Map<String, List<String>> substitutions() {
        return this.substitutions;
    }

    public String threadId() {
        return this.threadId;
    }

    public Integer timeToLive() {
        return this.timeToLive;
    }

    public String title() {
        return this.title;
    }

    public String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.badge());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.collapseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredAuthenticationMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.silentPush());
        hashCode = 31 * hashCode + Objects.hashCode(this.sound());
        hashCode = 31 * hashCode + Objects.hashCode(this.substitutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.threadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeToLive());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof APNSMessage)) {
            return false;
        }
        APNSMessage other = (APNSMessage)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.badge(), other.badge()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.category(), other.category()) && Objects.equals(this.collapseId(), other.collapseId()) && Objects.equals(this.data(), other.data()) && Objects.equals(this.mediaUrl(), other.mediaUrl()) && Objects.equals(this.preferredAuthenticationMethod(), other.preferredAuthenticationMethod()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.rawContent(), other.rawContent()) && Objects.equals(this.silentPush(), other.silentPush()) && Objects.equals(this.sound(), other.sound()) && Objects.equals(this.substitutions(), other.substitutions()) && Objects.equals(this.threadId(), other.threadId()) && Objects.equals(this.timeToLive(), other.timeToLive()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.url(), other.url());
    }

    public String toString() {
        return ToString.builder((String)"APNSMessage").add("Action", (Object)this.actionAsString()).add("Badge", (Object)this.badge()).add("Body", (Object)this.body()).add("Category", (Object)this.category()).add("CollapseId", (Object)this.collapseId()).add("Data", this.data()).add("MediaUrl", (Object)this.mediaUrl()).add("PreferredAuthenticationMethod", (Object)this.preferredAuthenticationMethod()).add("Priority", (Object)this.priority()).add("RawContent", (Object)this.rawContent()).add("SilentPush", (Object)this.silentPush()).add("Sound", (Object)this.sound()).add("Substitutions", this.substitutions()).add("ThreadId", (Object)this.threadId()).add("TimeToLive", (Object)this.timeToLive()).add("Title", (Object)this.title()).add("Url", (Object)this.url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.of(clazz.cast(this.actionAsString()));
            }
            case "Badge": {
                return Optional.of(clazz.cast(this.badge()));
            }
            case "Body": {
                return Optional.of(clazz.cast(this.body()));
            }
            case "Category": {
                return Optional.of(clazz.cast(this.category()));
            }
            case "CollapseId": {
                return Optional.of(clazz.cast(this.collapseId()));
            }
            case "Data": {
                return Optional.of(clazz.cast(this.data()));
            }
            case "MediaUrl": {
                return Optional.of(clazz.cast(this.mediaUrl()));
            }
            case "PreferredAuthenticationMethod": {
                return Optional.of(clazz.cast(this.preferredAuthenticationMethod()));
            }
            case "Priority": {
                return Optional.of(clazz.cast(this.priority()));
            }
            case "RawContent": {
                return Optional.of(clazz.cast(this.rawContent()));
            }
            case "SilentPush": {
                return Optional.of(clazz.cast(this.silentPush()));
            }
            case "Sound": {
                return Optional.of(clazz.cast(this.sound()));
            }
            case "Substitutions": {
                return Optional.of(clazz.cast(this.substitutions()));
            }
            case "ThreadId": {
                return Optional.of(clazz.cast(this.threadId()));
            }
            case "TimeToLive": {
                return Optional.of(clazz.cast(this.timeToLive()));
            }
            case "Title": {
                return Optional.of(clazz.cast(this.title()));
            }
            case "Url": {
                return Optional.of(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        APNSMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private Integer badge;
        private String body;
        private String category;
        private String collapseId;
        private Map<String, String> data;
        private String mediaUrl;
        private String preferredAuthenticationMethod;
        private String priority;
        private String rawContent;
        private Boolean silentPush;
        private String sound;
        private Map<String, List<String>> substitutions;
        private String threadId;
        private Integer timeToLive;
        private String title;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(APNSMessage model) {
            this.action(model.action);
            this.badge(model.badge);
            this.body(model.body);
            this.category(model.category);
            this.collapseId(model.collapseId);
            this.data(model.data);
            this.mediaUrl(model.mediaUrl);
            this.preferredAuthenticationMethod(model.preferredAuthenticationMethod);
            this.priority(model.priority);
            this.rawContent(model.rawContent);
            this.silentPush(model.silentPush);
            this.sound(model.sound);
            this.substitutions(model.substitutions);
            this.threadId(model.threadId);
            this.timeToLive(model.timeToLive);
            this.title(model.title);
            this.url(model.url);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final Integer getBadge() {
            return this.badge;
        }

        @Override
        public final Builder badge(Integer badge) {
            this.badge = badge;
            return this;
        }

        public final void setBadge(Integer badge) {
            this.badge = badge;
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getCollapseId() {
            return this.collapseId;
        }

        @Override
        public final Builder collapseId(String collapseId) {
            this.collapseId = collapseId;
            return this;
        }

        public final void setCollapseId(String collapseId) {
            this.collapseId = collapseId;
        }

        public final Map<String, String> getData() {
            return this.data;
        }

        @Override
        public final Builder data(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
            return this;
        }

        public final void setData(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
        }

        public final String getMediaUrl() {
            return this.mediaUrl;
        }

        @Override
        public final Builder mediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
            return this;
        }

        public final void setMediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
        }

        public final String getPreferredAuthenticationMethod() {
            return this.preferredAuthenticationMethod;
        }

        @Override
        public final Builder preferredAuthenticationMethod(String preferredAuthenticationMethod) {
            this.preferredAuthenticationMethod = preferredAuthenticationMethod;
            return this;
        }

        public final void setPreferredAuthenticationMethod(String preferredAuthenticationMethod) {
            this.preferredAuthenticationMethod = preferredAuthenticationMethod;
        }

        public final String getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(String priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(String priority) {
            this.priority = priority;
        }

        public final String getRawContent() {
            return this.rawContent;
        }

        @Override
        public final Builder rawContent(String rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        public final void setRawContent(String rawContent) {
            this.rawContent = rawContent;
        }

        public final Boolean getSilentPush() {
            return this.silentPush;
        }

        @Override
        public final Builder silentPush(Boolean silentPush) {
            this.silentPush = silentPush;
            return this;
        }

        public final void setSilentPush(Boolean silentPush) {
            this.silentPush = silentPush;
        }

        public final String getSound() {
            return this.sound;
        }

        @Override
        public final Builder sound(String sound) {
            this.sound = sound;
            return this;
        }

        public final void setSound(String sound) {
            this.sound = sound;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            return this.substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        public final String getThreadId() {
            return this.threadId;
        }

        @Override
        public final Builder threadId(String threadId) {
            this.threadId = threadId;
            return this;
        }

        public final void setThreadId(String threadId) {
            this.threadId = threadId;
        }

        public final Integer getTimeToLive() {
            return this.timeToLive;
        }

        @Override
        public final Builder timeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public final void setTimeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public APNSMessage build() {
            return new APNSMessage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, APNSMessage> {
        public Builder action(String var1);

        public Builder action(Action var1);

        public Builder badge(Integer var1);

        public Builder body(String var1);

        public Builder category(String var1);

        public Builder collapseId(String var1);

        public Builder data(Map<String, String> var1);

        public Builder mediaUrl(String var1);

        public Builder preferredAuthenticationMethod(String var1);

        public Builder priority(String var1);

        public Builder rawContent(String var1);

        public Builder silentPush(Boolean var1);

        public Builder sound(String var1);

        public Builder substitutions(Map<String, ? extends Collection<String>> var1);

        public Builder threadId(String var1);

        public Builder timeToLive(Integer var1);

        public Builder title(String var1);

        public Builder url(String var1);
    }
}

