/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.DefaultMessage;

@SdkInternalApi
public class DefaultMessageMarshaller {
    private static final MarshallingInfo<String> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Body").build();
    private static final MarshallingInfo<Map> SUBSTITUTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Substitutions").build();
    private static final DefaultMessageMarshaller instance = new DefaultMessageMarshaller();

    public static DefaultMessageMarshaller getInstance() {
        return instance;
    }

    public void marshall(DefaultMessage defaultMessage, ProtocolMarshaller protocolMarshaller) {
        if (defaultMessage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)defaultMessage.body(), BODY_BINDING);
            protocolMarshaller.marshall(defaultMessage.substitutions(), SUBSTITUTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

