/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.SegmentDimensions;
import software.amazon.awssdk.services.pinpoint.transform.WriteSegmentRequestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WriteSegmentRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, WriteSegmentRequest> {
    private final SegmentDimensions dimensions;
    private final String name;

    private WriteSegmentRequest(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.name = builder.name;
    }

    public SegmentDimensions dimensions() {
        return this.dimensions;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dimensions() == null ? 0 : this.dimensions().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteSegmentRequest)) {
            return false;
        }
        WriteSegmentRequest other = (WriteSegmentRequest)obj;
        if (other.dimensions() == null ^ this.dimensions() == null) {
            return false;
        }
        if (other.dimensions() != null && !other.dimensions().equals(this.dimensions())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        return other.name() == null || other.name().equals(this.name());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dimensions() != null) {
            sb.append("Dimensions: ").append(this.dimensions()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WriteSegmentRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private SegmentDimensions dimensions;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteSegmentRequest model) {
            this.setDimensions(model.dimensions);
            this.setName(model.name);
        }

        public final SegmentDimensions getDimensions() {
            return this.dimensions;
        }

        @Override
        public final Builder dimensions(SegmentDimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final void setDimensions(SegmentDimensions dimensions) {
            this.dimensions = dimensions;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public WriteSegmentRequest build() {
            return new WriteSegmentRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WriteSegmentRequest> {
        public Builder dimensions(SegmentDimensions var1);

        public Builder name(String var1);
    }
}

