/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.pinpoint.model.EndpointRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateEndpointRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateEndpointRequest> {
    private final String applicationId;
    private final String endpointId;
    private final EndpointRequest endpointRequest;

    private UpdateEndpointRequest(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.endpointId = builder.endpointId;
        this.endpointRequest = builder.endpointRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String endpointId() {
        return this.endpointId;
    }

    public EndpointRequest endpointRequest() {
        return this.endpointRequest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationId() == null ? 0 : this.applicationId().hashCode());
        hashCode = 31 * hashCode + (this.endpointId() == null ? 0 : this.endpointId().hashCode());
        hashCode = 31 * hashCode + (this.endpointRequest() == null ? 0 : this.endpointRequest().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointRequest)) {
            return false;
        }
        UpdateEndpointRequest other = (UpdateEndpointRequest)((Object)obj);
        if (other.applicationId() == null ^ this.applicationId() == null) {
            return false;
        }
        if (other.applicationId() != null && !other.applicationId().equals(this.applicationId())) {
            return false;
        }
        if (other.endpointId() == null ^ this.endpointId() == null) {
            return false;
        }
        if (other.endpointId() != null && !other.endpointId().equals(this.endpointId())) {
            return false;
        }
        if (other.endpointRequest() == null ^ this.endpointRequest() == null) {
            return false;
        }
        return other.endpointRequest() == null || other.endpointRequest().equals(this.endpointRequest());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.endpointId() != null) {
            sb.append("EndpointId: ").append(this.endpointId()).append(",");
        }
        if (this.endpointRequest() != null) {
            sb.append("EndpointRequest: ").append(this.endpointRequest()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String endpointId;
        private EndpointRequest endpointRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndpointRequest model) {
            this.setApplicationId(model.applicationId);
            this.setEndpointId(model.endpointId);
            this.setEndpointRequest(model.endpointRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getEndpointId() {
            return this.endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        public final EndpointRequest getEndpointRequest() {
            return this.endpointRequest;
        }

        @Override
        public final Builder endpointRequest(EndpointRequest endpointRequest) {
            this.endpointRequest = endpointRequest;
            return this;
        }

        public final void setEndpointRequest(EndpointRequest endpointRequest) {
            this.endpointRequest = endpointRequest;
        }

        public UpdateEndpointRequest build() {
            return new UpdateEndpointRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateEndpointRequest> {
        public Builder applicationId(String var1);

        public Builder endpointId(String var1);

        public Builder endpointRequest(EndpointRequest var1);
    }
}

