/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.CampaignState;
import software.amazon.awssdk.services.pinpoint.model.MessageConfiguration;
import software.amazon.awssdk.services.pinpoint.model.Schedule;
import software.amazon.awssdk.services.pinpoint.transform.TreatmentResourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TreatmentResource
implements StructuredPojo,
ToCopyableBuilder<Builder, TreatmentResource> {
    private final String id;
    private final MessageConfiguration messageConfiguration;
    private final Schedule schedule;
    private final Integer sizePercent;
    private final CampaignState state;
    private final String treatmentDescription;
    private final String treatmentName;

    private TreatmentResource(BuilderImpl builder) {
        this.id = builder.id;
        this.messageConfiguration = builder.messageConfiguration;
        this.schedule = builder.schedule;
        this.sizePercent = builder.sizePercent;
        this.state = builder.state;
        this.treatmentDescription = builder.treatmentDescription;
        this.treatmentName = builder.treatmentName;
    }

    public String id() {
        return this.id;
    }

    public MessageConfiguration messageConfiguration() {
        return this.messageConfiguration;
    }

    public Schedule schedule() {
        return this.schedule;
    }

    public Integer sizePercent() {
        return this.sizePercent;
    }

    public CampaignState state() {
        return this.state;
    }

    public String treatmentDescription() {
        return this.treatmentDescription;
    }

    public String treatmentName() {
        return this.treatmentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.messageConfiguration() == null ? 0 : this.messageConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.schedule() == null ? 0 : this.schedule().hashCode());
        hashCode = 31 * hashCode + (this.sizePercent() == null ? 0 : this.sizePercent().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.treatmentDescription() == null ? 0 : this.treatmentDescription().hashCode());
        hashCode = 31 * hashCode + (this.treatmentName() == null ? 0 : this.treatmentName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TreatmentResource)) {
            return false;
        }
        TreatmentResource other = (TreatmentResource)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.messageConfiguration() == null ^ this.messageConfiguration() == null) {
            return false;
        }
        if (other.messageConfiguration() != null && !other.messageConfiguration().equals(this.messageConfiguration())) {
            return false;
        }
        if (other.schedule() == null ^ this.schedule() == null) {
            return false;
        }
        if (other.schedule() != null && !other.schedule().equals(this.schedule())) {
            return false;
        }
        if (other.sizePercent() == null ^ this.sizePercent() == null) {
            return false;
        }
        if (other.sizePercent() != null && !other.sizePercent().equals(this.sizePercent())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.treatmentDescription() == null ^ this.treatmentDescription() == null) {
            return false;
        }
        if (other.treatmentDescription() != null && !other.treatmentDescription().equals(this.treatmentDescription())) {
            return false;
        }
        if (other.treatmentName() == null ^ this.treatmentName() == null) {
            return false;
        }
        return other.treatmentName() == null || other.treatmentName().equals(this.treatmentName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.messageConfiguration() != null) {
            sb.append("MessageConfiguration: ").append(this.messageConfiguration()).append(",");
        }
        if (this.schedule() != null) {
            sb.append("Schedule: ").append(this.schedule()).append(",");
        }
        if (this.sizePercent() != null) {
            sb.append("SizePercent: ").append(this.sizePercent()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.treatmentDescription() != null) {
            sb.append("TreatmentDescription: ").append(this.treatmentDescription()).append(",");
        }
        if (this.treatmentName() != null) {
            sb.append("TreatmentName: ").append(this.treatmentName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TreatmentResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private MessageConfiguration messageConfiguration;
        private Schedule schedule;
        private Integer sizePercent;
        private CampaignState state;
        private String treatmentDescription;
        private String treatmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(TreatmentResource model) {
            this.setId(model.id);
            this.setMessageConfiguration(model.messageConfiguration);
            this.setSchedule(model.schedule);
            this.setSizePercent(model.sizePercent);
            this.setState(model.state);
            this.setTreatmentDescription(model.treatmentDescription);
            this.setTreatmentName(model.treatmentName);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final MessageConfiguration getMessageConfiguration() {
            return this.messageConfiguration;
        }

        @Override
        public final Builder messageConfiguration(MessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final void setMessageConfiguration(MessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
        }

        public final Schedule getSchedule() {
            return this.schedule;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(Schedule schedule) {
            this.schedule = schedule;
        }

        public final Integer getSizePercent() {
            return this.sizePercent;
        }

        @Override
        public final Builder sizePercent(Integer sizePercent) {
            this.sizePercent = sizePercent;
            return this;
        }

        public final void setSizePercent(Integer sizePercent) {
            this.sizePercent = sizePercent;
        }

        public final CampaignState getState() {
            return this.state;
        }

        @Override
        public final Builder state(CampaignState state) {
            this.state = state;
            return this;
        }

        public final void setState(CampaignState state) {
            this.state = state;
        }

        public final String getTreatmentDescription() {
            return this.treatmentDescription;
        }

        @Override
        public final Builder treatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
            return this;
        }

        public final void setTreatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
        }

        public final String getTreatmentName() {
            return this.treatmentName;
        }

        @Override
        public final Builder treatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
            return this;
        }

        public final void setTreatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
        }

        public TreatmentResource build() {
            return new TreatmentResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TreatmentResource> {
        public Builder id(String var1);

        public Builder messageConfiguration(MessageConfiguration var1);

        public Builder schedule(Schedule var1);

        public Builder sizePercent(Integer var1);

        public Builder state(CampaignState var1);

        public Builder treatmentDescription(String var1);

        public Builder treatmentName(String var1);
    }
}

