/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.Format;
import software.amazon.awssdk.services.pinpoint.model.MapOf__integerCopier;
import software.amazon.awssdk.services.pinpoint.transform.SegmentImportResourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SegmentImportResource
implements StructuredPojo,
ToCopyableBuilder<Builder, SegmentImportResource> {
    private final Map<String, Integer> channelCounts;
    private final String externalId;
    private final String format;
    private final String roleArn;
    private final String s3Url;
    private final Integer size;

    private SegmentImportResource(BuilderImpl builder) {
        this.channelCounts = builder.channelCounts;
        this.externalId = builder.externalId;
        this.format = builder.format;
        this.roleArn = builder.roleArn;
        this.s3Url = builder.s3Url;
        this.size = builder.size;
    }

    public Map<String, Integer> channelCounts() {
        return this.channelCounts;
    }

    public String externalId() {
        return this.externalId;
    }

    public String format() {
        return this.format;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String s3Url() {
        return this.s3Url;
    }

    public Integer size() {
        return this.size;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.channelCounts() == null ? 0 : this.channelCounts().hashCode());
        hashCode = 31 * hashCode + (this.externalId() == null ? 0 : this.externalId().hashCode());
        hashCode = 31 * hashCode + (this.format() == null ? 0 : this.format().hashCode());
        hashCode = 31 * hashCode + (this.roleArn() == null ? 0 : this.roleArn().hashCode());
        hashCode = 31 * hashCode + (this.s3Url() == null ? 0 : this.s3Url().hashCode());
        hashCode = 31 * hashCode + (this.size() == null ? 0 : this.size().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentImportResource)) {
            return false;
        }
        SegmentImportResource other = (SegmentImportResource)obj;
        if (other.channelCounts() == null ^ this.channelCounts() == null) {
            return false;
        }
        if (other.channelCounts() != null && !other.channelCounts().equals(this.channelCounts())) {
            return false;
        }
        if (other.externalId() == null ^ this.externalId() == null) {
            return false;
        }
        if (other.externalId() != null && !other.externalId().equals(this.externalId())) {
            return false;
        }
        if (other.format() == null ^ this.format() == null) {
            return false;
        }
        if (other.format() != null && !other.format().equals(this.format())) {
            return false;
        }
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        if (other.roleArn() != null && !other.roleArn().equals(this.roleArn())) {
            return false;
        }
        if (other.s3Url() == null ^ this.s3Url() == null) {
            return false;
        }
        if (other.s3Url() != null && !other.s3Url().equals(this.s3Url())) {
            return false;
        }
        if (other.size() == null ^ this.size() == null) {
            return false;
        }
        return other.size() == null || other.size().equals(this.size());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.channelCounts() != null) {
            sb.append("ChannelCounts: ").append(this.channelCounts()).append(",");
        }
        if (this.externalId() != null) {
            sb.append("ExternalId: ").append(this.externalId()).append(",");
        }
        if (this.format() != null) {
            sb.append("Format: ").append(this.format()).append(",");
        }
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (this.s3Url() != null) {
            sb.append("S3Url: ").append(this.s3Url()).append(",");
        }
        if (this.size() != null) {
            sb.append("Size: ").append(this.size()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SegmentImportResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Map<String, Integer> channelCounts;
        private String externalId;
        private String format;
        private String roleArn;
        private String s3Url;
        private Integer size;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentImportResource model) {
            this.setChannelCounts(model.channelCounts);
            this.setExternalId(model.externalId);
            this.setFormat(model.format);
            this.setRoleArn(model.roleArn);
            this.setS3Url(model.s3Url);
            this.setSize(model.size);
        }

        public final Map<String, Integer> getChannelCounts() {
            return this.channelCounts;
        }

        @Override
        public final Builder channelCounts(Map<String, Integer> channelCounts) {
            this.channelCounts = MapOf__integerCopier.copy(channelCounts);
            return this;
        }

        public final void setChannelCounts(Map<String, Integer> channelCounts) {
            this.channelCounts = MapOf__integerCopier.copy(channelCounts);
        }

        public final String getExternalId() {
            return this.externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final void setFormat(Format format) {
            this.format(format.toString());
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getS3Url() {
            return this.s3Url;
        }

        @Override
        public final Builder s3Url(String s3Url) {
            this.s3Url = s3Url;
            return this;
        }

        public final void setS3Url(String s3Url) {
            this.s3Url = s3Url;
        }

        public final Integer getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public SegmentImportResource build() {
            return new SegmentImportResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SegmentImportResource> {
        public Builder channelCounts(Map<String, Integer> var1);

        public Builder externalId(String var1);

        public Builder format(String var1);

        public Builder format(Format var1);

        public Builder roleArn(String var1);

        public Builder s3Url(String var1);

        public Builder size(Integer var1);
    }
}

