/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.Frequency;
import software.amazon.awssdk.services.pinpoint.model.QuietTime;
import software.amazon.awssdk.services.pinpoint.transform.ScheduleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Schedule
implements StructuredPojo,
ToCopyableBuilder<Builder, Schedule> {
    private final String endTime;
    private final String frequency;
    private final Boolean isLocalTime;
    private final QuietTime quietTime;
    private final String startTime;
    private final String timezone;

    private Schedule(BuilderImpl builder) {
        this.endTime = builder.endTime;
        this.frequency = builder.frequency;
        this.isLocalTime = builder.isLocalTime;
        this.quietTime = builder.quietTime;
        this.startTime = builder.startTime;
        this.timezone = builder.timezone;
    }

    public String endTime() {
        return this.endTime;
    }

    public String frequency() {
        return this.frequency;
    }

    public Boolean isLocalTime() {
        return this.isLocalTime;
    }

    public QuietTime quietTime() {
        return this.quietTime;
    }

    public String startTime() {
        return this.startTime;
    }

    public String timezone() {
        return this.timezone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.frequency() == null ? 0 : this.frequency().hashCode());
        hashCode = 31 * hashCode + (this.isLocalTime() == null ? 0 : this.isLocalTime().hashCode());
        hashCode = 31 * hashCode + (this.quietTime() == null ? 0 : this.quietTime().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.timezone() == null ? 0 : this.timezone().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule)obj;
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.frequency() == null ^ this.frequency() == null) {
            return false;
        }
        if (other.frequency() != null && !other.frequency().equals(this.frequency())) {
            return false;
        }
        if (other.isLocalTime() == null ^ this.isLocalTime() == null) {
            return false;
        }
        if (other.isLocalTime() != null && !other.isLocalTime().equals(this.isLocalTime())) {
            return false;
        }
        if (other.quietTime() == null ^ this.quietTime() == null) {
            return false;
        }
        if (other.quietTime() != null && !other.quietTime().equals(this.quietTime())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.timezone() == null ^ this.timezone() == null) {
            return false;
        }
        return other.timezone() == null || other.timezone().equals(this.timezone());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.frequency() != null) {
            sb.append("Frequency: ").append(this.frequency()).append(",");
        }
        if (this.isLocalTime() != null) {
            sb.append("IsLocalTime: ").append(this.isLocalTime()).append(",");
        }
        if (this.quietTime() != null) {
            sb.append("QuietTime: ").append(this.quietTime()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.timezone() != null) {
            sb.append("Timezone: ").append(this.timezone()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScheduleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String endTime;
        private String frequency;
        private Boolean isLocalTime;
        private QuietTime quietTime;
        private String startTime;
        private String timezone;

        private BuilderImpl() {
        }

        private BuilderImpl(Schedule model) {
            this.setEndTime(model.endTime);
            this.setFrequency(model.frequency);
            this.setIsLocalTime(model.isLocalTime);
            this.setQuietTime(model.quietTime);
            this.setStartTime(model.startTime);
            this.setTimezone(model.timezone);
        }

        public final String getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public final String getFrequency() {
            return this.frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(Frequency frequency) {
            this.frequency(frequency.toString());
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public final void setFrequency(Frequency frequency) {
            this.frequency(frequency.toString());
        }

        public final Boolean getIsLocalTime() {
            return this.isLocalTime;
        }

        @Override
        public final Builder isLocalTime(Boolean isLocalTime) {
            this.isLocalTime = isLocalTime;
            return this;
        }

        public final void setIsLocalTime(Boolean isLocalTime) {
            this.isLocalTime = isLocalTime;
        }

        public final QuietTime getQuietTime() {
            return this.quietTime;
        }

        @Override
        public final Builder quietTime(QuietTime quietTime) {
            this.quietTime = quietTime;
            return this;
        }

        public final void setQuietTime(QuietTime quietTime) {
            this.quietTime = quietTime;
        }

        public final String getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public Schedule build() {
            return new Schedule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Schedule> {
        public Builder endTime(String var1);

        public Builder frequency(String var1);

        public Builder frequency(Frequency var1);

        public Builder isLocalTime(Boolean var1);

        public Builder quietTime(QuietTime var1);

        public Builder startTime(String var1);

        public Builder timezone(String var1);
    }
}

