/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.SMSChannelRequestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SMSChannelRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, SMSChannelRequest> {
    private final Boolean enabled;
    private final String senderId;

    private SMSChannelRequest(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.senderId = builder.senderId;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String senderId() {
        return this.senderId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.senderId() == null ? 0 : this.senderId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SMSChannelRequest)) {
            return false;
        }
        SMSChannelRequest other = (SMSChannelRequest)obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.senderId() == null ^ this.senderId() == null) {
            return false;
        }
        return other.senderId() == null || other.senderId().equals(this.senderId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.senderId() != null) {
            sb.append("SenderId: ").append(this.senderId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SMSChannelRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String senderId;

        private BuilderImpl() {
        }

        private BuilderImpl(SMSChannelRequest model) {
            this.setEnabled(model.enabled);
            this.setSenderId(model.senderId);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getSenderId() {
            return this.senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        public SMSChannelRequest build() {
            return new SMSChannelRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SMSChannelRequest> {
        public Builder enabled(Boolean var1);

        public Builder senderId(String var1);
    }
}

