/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetEndpointRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetEndpointRequest> {
    private final String applicationId;
    private final String endpointId;

    private GetEndpointRequest(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.endpointId = builder.endpointId;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String endpointId() {
        return this.endpointId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationId() == null ? 0 : this.applicationId().hashCode());
        hashCode = 31 * hashCode + (this.endpointId() == null ? 0 : this.endpointId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEndpointRequest)) {
            return false;
        }
        GetEndpointRequest other = (GetEndpointRequest)((Object)obj);
        if (other.applicationId() == null ^ this.applicationId() == null) {
            return false;
        }
        if (other.applicationId() != null && !other.applicationId().equals(this.applicationId())) {
            return false;
        }
        if (other.endpointId() == null ^ this.endpointId() == null) {
            return false;
        }
        return other.endpointId() == null || other.endpointId().equals(this.endpointId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.endpointId() != null) {
            sb.append("EndpointId: ").append(this.endpointId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String endpointId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEndpointRequest model) {
            this.setApplicationId(model.applicationId);
            this.setEndpointId(model.endpointId);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getEndpointId() {
            return this.endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        public GetEndpointRequest build() {
            return new GetEndpointRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetEndpointRequest> {
        public Builder applicationId(String var1);

        public Builder endpointId(String var1);
    }
}

