/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.ChannelType;
import software.amazon.awssdk.services.pinpoint.model.EndpointDemographic;
import software.amazon.awssdk.services.pinpoint.model.EndpointLocation;
import software.amazon.awssdk.services.pinpoint.model.EndpointUser;
import software.amazon.awssdk.services.pinpoint.model.MapOfListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__doubleCopier;
import software.amazon.awssdk.services.pinpoint.transform.EndpointBatchItemMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EndpointBatchItem
implements StructuredPojo,
ToCopyableBuilder<Builder, EndpointBatchItem> {
    private final String address;
    private final Map<String, List<String>> attributes;
    private final String channelType;
    private final EndpointDemographic demographic;
    private final String effectiveDate;
    private final String endpointStatus;
    private final String id;
    private final EndpointLocation location;
    private final Map<String, Double> metrics;
    private final String optOut;
    private final String requestId;
    private final EndpointUser user;

    private EndpointBatchItem(BuilderImpl builder) {
        this.address = builder.address;
        this.attributes = builder.attributes;
        this.channelType = builder.channelType;
        this.demographic = builder.demographic;
        this.effectiveDate = builder.effectiveDate;
        this.endpointStatus = builder.endpointStatus;
        this.id = builder.id;
        this.location = builder.location;
        this.metrics = builder.metrics;
        this.optOut = builder.optOut;
        this.requestId = builder.requestId;
        this.user = builder.user;
    }

    public String address() {
        return this.address;
    }

    public Map<String, List<String>> attributes() {
        return this.attributes;
    }

    public String channelType() {
        return this.channelType;
    }

    public EndpointDemographic demographic() {
        return this.demographic;
    }

    public String effectiveDate() {
        return this.effectiveDate;
    }

    public String endpointStatus() {
        return this.endpointStatus;
    }

    public String id() {
        return this.id;
    }

    public EndpointLocation location() {
        return this.location;
    }

    public Map<String, Double> metrics() {
        return this.metrics;
    }

    public String optOut() {
        return this.optOut;
    }

    public String requestId() {
        return this.requestId;
    }

    public EndpointUser user() {
        return this.user;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.address() == null ? 0 : this.address().hashCode());
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        hashCode = 31 * hashCode + (this.channelType() == null ? 0 : this.channelType().hashCode());
        hashCode = 31 * hashCode + (this.demographic() == null ? 0 : this.demographic().hashCode());
        hashCode = 31 * hashCode + (this.effectiveDate() == null ? 0 : this.effectiveDate().hashCode());
        hashCode = 31 * hashCode + (this.endpointStatus() == null ? 0 : this.endpointStatus().hashCode());
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.location() == null ? 0 : this.location().hashCode());
        hashCode = 31 * hashCode + (this.metrics() == null ? 0 : this.metrics().hashCode());
        hashCode = 31 * hashCode + (this.optOut() == null ? 0 : this.optOut().hashCode());
        hashCode = 31 * hashCode + (this.requestId() == null ? 0 : this.requestId().hashCode());
        hashCode = 31 * hashCode + (this.user() == null ? 0 : this.user().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointBatchItem)) {
            return false;
        }
        EndpointBatchItem other = (EndpointBatchItem)obj;
        if (other.address() == null ^ this.address() == null) {
            return false;
        }
        if (other.address() != null && !other.address().equals(this.address())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        if (other.attributes() != null && !other.attributes().equals(this.attributes())) {
            return false;
        }
        if (other.channelType() == null ^ this.channelType() == null) {
            return false;
        }
        if (other.channelType() != null && !other.channelType().equals(this.channelType())) {
            return false;
        }
        if (other.demographic() == null ^ this.demographic() == null) {
            return false;
        }
        if (other.demographic() != null && !other.demographic().equals(this.demographic())) {
            return false;
        }
        if (other.effectiveDate() == null ^ this.effectiveDate() == null) {
            return false;
        }
        if (other.effectiveDate() != null && !other.effectiveDate().equals(this.effectiveDate())) {
            return false;
        }
        if (other.endpointStatus() == null ^ this.endpointStatus() == null) {
            return false;
        }
        if (other.endpointStatus() != null && !other.endpointStatus().equals(this.endpointStatus())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.metrics() == null ^ this.metrics() == null) {
            return false;
        }
        if (other.metrics() != null && !other.metrics().equals(this.metrics())) {
            return false;
        }
        if (other.optOut() == null ^ this.optOut() == null) {
            return false;
        }
        if (other.optOut() != null && !other.optOut().equals(this.optOut())) {
            return false;
        }
        if (other.requestId() == null ^ this.requestId() == null) {
            return false;
        }
        if (other.requestId() != null && !other.requestId().equals(this.requestId())) {
            return false;
        }
        if (other.user() == null ^ this.user() == null) {
            return false;
        }
        return other.user() == null || other.user().equals(this.user());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.address() != null) {
            sb.append("Address: ").append(this.address()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (this.channelType() != null) {
            sb.append("ChannelType: ").append(this.channelType()).append(",");
        }
        if (this.demographic() != null) {
            sb.append("Demographic: ").append(this.demographic()).append(",");
        }
        if (this.effectiveDate() != null) {
            sb.append("EffectiveDate: ").append(this.effectiveDate()).append(",");
        }
        if (this.endpointStatus() != null) {
            sb.append("EndpointStatus: ").append(this.endpointStatus()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.metrics() != null) {
            sb.append("Metrics: ").append(this.metrics()).append(",");
        }
        if (this.optOut() != null) {
            sb.append("OptOut: ").append(this.optOut()).append(",");
        }
        if (this.requestId() != null) {
            sb.append("RequestId: ").append(this.requestId()).append(",");
        }
        if (this.user() != null) {
            sb.append("User: ").append(this.user()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointBatchItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String address;
        private Map<String, List<String>> attributes;
        private String channelType;
        private EndpointDemographic demographic;
        private String effectiveDate;
        private String endpointStatus;
        private String id;
        private EndpointLocation location;
        private Map<String, Double> metrics;
        private String optOut;
        private String requestId;
        private EndpointUser user;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointBatchItem model) {
            this.setAddress(model.address);
            this.setAttributes(model.attributes);
            this.setChannelType(model.channelType);
            this.setDemographic(model.demographic);
            this.setEffectiveDate(model.effectiveDate);
            this.setEndpointStatus(model.endpointStatus);
            this.setId(model.id);
            this.setLocation(model.location);
            this.setMetrics(model.metrics);
            this.setOptOut(model.optOut);
            this.setRequestId(model.requestId);
            this.setUser(model.user);
        }

        public final String getAddress() {
            return this.address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final Map<String, ? extends Collection<String>> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, ? extends Collection<String>> attributes) {
            this.attributes = MapOfListOf__stringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, ? extends Collection<String>> attributes) {
            this.attributes = MapOfListOf__stringCopier.copy(attributes);
        }

        public final String getChannelType() {
            return this.channelType;
        }

        @Override
        public final Builder channelType(String channelType) {
            this.channelType = channelType;
            return this;
        }

        @Override
        public final Builder channelType(ChannelType channelType) {
            this.channelType(channelType.toString());
            return this;
        }

        public final void setChannelType(String channelType) {
            this.channelType = channelType;
        }

        public final void setChannelType(ChannelType channelType) {
            this.channelType(channelType.toString());
        }

        public final EndpointDemographic getDemographic() {
            return this.demographic;
        }

        @Override
        public final Builder demographic(EndpointDemographic demographic) {
            this.demographic = demographic;
            return this;
        }

        public final void setDemographic(EndpointDemographic demographic) {
            this.demographic = demographic;
        }

        public final String getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public final Builder effectiveDate(String effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public final void setEffectiveDate(String effectiveDate) {
            this.effectiveDate = effectiveDate;
        }

        public final String getEndpointStatus() {
            return this.endpointStatus;
        }

        @Override
        public final Builder endpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
            return this;
        }

        public final void setEndpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final EndpointLocation getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(EndpointLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(EndpointLocation location) {
            this.location = location;
        }

        public final Map<String, Double> getMetrics() {
            return this.metrics;
        }

        @Override
        public final Builder metrics(Map<String, Double> metrics) {
            this.metrics = MapOf__doubleCopier.copy(metrics);
            return this;
        }

        public final void setMetrics(Map<String, Double> metrics) {
            this.metrics = MapOf__doubleCopier.copy(metrics);
        }

        public final String getOptOut() {
            return this.optOut;
        }

        @Override
        public final Builder optOut(String optOut) {
            this.optOut = optOut;
            return this;
        }

        public final void setOptOut(String optOut) {
            this.optOut = optOut;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final EndpointUser getUser() {
            return this.user;
        }

        @Override
        public final Builder user(EndpointUser user) {
            this.user = user;
            return this;
        }

        public final void setUser(EndpointUser user) {
            this.user = user;
        }

        public EndpointBatchItem build() {
            return new EndpointBatchItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EndpointBatchItem> {
        public Builder address(String var1);

        public Builder attributes(Map<String, ? extends Collection<String>> var1);

        public Builder channelType(String var1);

        public Builder channelType(ChannelType var1);

        public Builder demographic(EndpointDemographic var1);

        public Builder effectiveDate(String var1);

        public Builder endpointStatus(String var1);

        public Builder id(String var1);

        public Builder location(EndpointLocation var1);

        public Builder metrics(Map<String, Double> var1);

        public Builder optOut(String var1);

        public Builder requestId(String var1);

        public Builder user(EndpointUser var1);
    }
}

