/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.CampaignEmailMessageMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CampaignEmailMessage
implements StructuredPojo,
ToCopyableBuilder<Builder, CampaignEmailMessage> {
    private final String body;
    private final String htmlBody;
    private final String title;

    private CampaignEmailMessage(BuilderImpl builder) {
        this.body = builder.body;
        this.htmlBody = builder.htmlBody;
        this.title = builder.title;
    }

    public String body() {
        return this.body;
    }

    public String htmlBody() {
        return this.htmlBody;
    }

    public String title() {
        return this.title;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.body() == null ? 0 : this.body().hashCode());
        hashCode = 31 * hashCode + (this.htmlBody() == null ? 0 : this.htmlBody().hashCode());
        hashCode = 31 * hashCode + (this.title() == null ? 0 : this.title().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignEmailMessage)) {
            return false;
        }
        CampaignEmailMessage other = (CampaignEmailMessage)obj;
        if (other.body() == null ^ this.body() == null) {
            return false;
        }
        if (other.body() != null && !other.body().equals(this.body())) {
            return false;
        }
        if (other.htmlBody() == null ^ this.htmlBody() == null) {
            return false;
        }
        if (other.htmlBody() != null && !other.htmlBody().equals(this.htmlBody())) {
            return false;
        }
        if (other.title() == null ^ this.title() == null) {
            return false;
        }
        return other.title() == null || other.title().equals(this.title());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.body() != null) {
            sb.append("Body: ").append(this.body()).append(",");
        }
        if (this.htmlBody() != null) {
            sb.append("HtmlBody: ").append(this.htmlBody()).append(",");
        }
        if (this.title() != null) {
            sb.append("Title: ").append(this.title()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CampaignEmailMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String body;
        private String htmlBody;
        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignEmailMessage model) {
            this.setBody(model.body);
            this.setHtmlBody(model.htmlBody);
            this.setTitle(model.title);
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getHtmlBody() {
            return this.htmlBody;
        }

        @Override
        public final Builder htmlBody(String htmlBody) {
            this.htmlBody = htmlBody;
            return this;
        }

        public final void setHtmlBody(String htmlBody) {
            this.htmlBody = htmlBody;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public CampaignEmailMessage build() {
            return new CampaignEmailMessage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CampaignEmailMessage> {
        public Builder body(String var1);

        public Builder htmlBody(String var1);

        public Builder title(String var1);
    }
}

